package com.biz.crm.sfa.business.action.scheme.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeStoreTypeEntity;
import com.biz.crm.sfa.business.action.scheme.local.mapper.SchemeStoreTypeMapper;
import org.springframework.stereotype.Component;

/**
 * 方案门店类型表的数据库访问类 {@link SchemeStoreTypeEntity}
 *
 * @author ning.zhang
 * @date 2022-08-05 14:32:21
 */
@Component
public class SchemeStoreTypeRepository extends ServiceImpl<SchemeStoreTypeMapper, SchemeStoreTypeEntity> {

  /**
   * 通过方案ID删除方案门店类型信息
   *
   * @param schemeId 方案ID
   */
  public void deleteBySchemeId(String schemeId) {
    this.lambdaUpdate()
        .eq(SchemeStoreTypeEntity::getSchemeId, schemeId)
        .remove();
  }
}
