package com.biz.crm.sfa.business.action.scheme.local.service;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeActionEntity;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionDto;

import java.util.List;

/**
 * 方案活动活动表服务接口
 *
 * @author ning.zhang
 * @date 2022-08-09 17:17:19
 */
public interface SchemeActionService {

  /**
   * 创建方案活动
   *
   * @param dto 请求参数dto
   * @return 方案活动实体
   */
  SchemeActionEntity create(SchemeActionDto dto);

  /**
   * 更新方案活动
   *
   * @param dto 请求参数dto
   * @return 方案活动实体
   */
  SchemeActionEntity update(SchemeActionDto dto);

  /**
   * 批量删除方案活动
   *
   * @param ids 方案活动id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量关闭方案活动
   *
   * @param ids 方案活动id集合
   */
  void closeBatch(List<String> ids);
}
