package com.biz.crm.sfa.business.action.scheme.local.service;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayEntity;

import java.util.List;

/**
 * 陈列方案表服务接口
 *
 * @author ning.zhang
 * @date 2022-08-08 14:11:49
 */
public interface SchemeDisplayService {

  /**
   * 更新陈列方案
   *
   * @param entity 更新的陈列方案实体
   * @return 陈列方案实体
   */
  SchemeDisplayEntity update(SchemeDisplayEntity entity);

  /**
   * 批量删除陈列方案
   *
   * @param schemeCodes 方案编码集合
   */
  void deleteBatch(List<String> schemeCodes);

  /**
   * 批量启用陈列方案
   *
   * @param schemeCodes 方案编码集合
   */
  void enableBatch(List<String> schemeCodes);

  /**
   * 批量禁用陈列方案
   *
   * @param schemeCodes 方案编码集合
   */
  void disableBatch(List<String> schemeCodes);
}
