package com.biz.crm.sfa.business.action.scheme.local.service;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeDto;

import java.util.List;

/**
 * 方案表服务接口
 *
 * @author ning.zhang
 * @date 2022-08-05 14:32:18
 */
public interface SchemeService {

  /**
   * 创建方案
   *
   * @param dto 请求参数dto
   * @return 方案实体
   */
  SchemeEntity create(SchemeDto dto);

  /**
   * 更新方案
   *
   * @param dto 请求参数dto
   * @return 方案实体
   */
  SchemeEntity update(SchemeDto dto);

  /**
   * 批量删除方案
   *
   * @param ids 方案id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用方案
   *
   * @param ids 方案id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用方案
   *
   * @param ids 方案id集合
   */
  void disableBatch(List<String> ids);
}
