package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.sdk.register.SchemeActionExchangeRegister;
import com.biz.crm.sfa.business.action.scheme.sdk.service.SchemeActionExchangeTypeVoService;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeActionExchangeTypeVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 方案活动兑付类型vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/8/9
 */
@Slf4j
@Service
public class SchemeActionExchangeTypeVoServiceImpl implements SchemeActionExchangeTypeVoService {

  @Autowired(required = false)
  private List<SchemeActionExchangeRegister> registers;

  @Override
  public List<SchemeActionExchangeTypeVo> findAll() {
    if (CollectionUtils.isEmpty(registers)) {
      return Lists.newLinkedList();
    }
    return this.registers.stream().map(register -> {
      SchemeActionExchangeTypeVo typeVo = new SchemeActionExchangeTypeVo();
      typeVo.setTypeKey(register.getTypeKey());
      typeVo.setTypeName(register.getTypeName());
      return typeVo;
    }).collect(Collectors.toList());
  }
}
