package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeActionConditionModel;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeActionVoRepository;
import com.biz.crm.sfa.business.action.scheme.sdk.constant.SchemeActionConstant;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.service.SchemeActionVoService;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeActionVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * 方案活动Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/8/10
 */
@Slf4j
@Service
public class SchemeActionVoServiceImpl implements SchemeActionVoService {

  @Autowired
  private SchemeActionVoRepository schemeActionVoRepository;
  @Autowired
  private ProcessBusinessMappingService processBusinessMappingService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<SchemeActionVo> findByConditions(Pageable pageable, SchemeActionPageDto dto) {
    //TODO 此处方案活动的执行,还未完成(执行终端数量字段还无法统计),暂时去掉审批状态,
    //TODO 待全部完成后移到boot中去使用统一列表
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new SchemeActionPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return this.schemeActionVoRepository.findByConditions(pageable, dto);
  }

  @Override
  public SchemeActionVo findById(String id) {
    if (Objects.isNull(id)) {
      return null;
    }
    SchemeActionConditionModel model = new SchemeActionConditionModel();
    model.setIds(Sets.newHashSet(id));
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    List<SchemeActionVo> schemeActions = this.schemeActionVoRepository.findBySchemeActionConditionModel(model);
    if (CollectionUtils.isEmpty(schemeActions)) {
      return null;
    }
    SchemeActionVo schemeActionVo = schemeActions.get(0);
    ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
    businessMappingDto.setBusinessCode(SchemeActionConstant.SCHEME_ACTION_PROCESS_FORM_TYPE);
    businessMappingDto.setBusinessNo(schemeActionVo.getActionCode());
    ProcessBusinessMappingVo businessMappingVo = this.processBusinessMappingService.findSignalByConditions(businessMappingDto);
    if (Objects.nonNull(businessMappingVo)) {
      schemeActionVo.setProcessBusiness(this.nebulaToolkitService.copyObjectByWhiteList(businessMappingVo, ProcessBusinessVo.class, HashSet.class, ArrayList.class));
    }
    return schemeActionVo;
  }
}
