package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayProductRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayProductService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 陈列方案产品表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-08 14:11:50
 */
@Slf4j
@Service("schemeDisplayProductService")
public class SchemeDisplayProductServiceImpl implements SchemeDisplayProductService {

  @Autowired
  private SchemeDisplayProductRepository schemeDisplayProductRepository;

  @Override
  @Transactional
  public void update(SchemeDisplayEntity displayEntity) {
    this.updateValidation(displayEntity);
    this.schemeDisplayProductRepository.saveBatch(displayEntity.getProductList());
  }

  /**
   * 在修改SchemeDisplayProduct模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param displayEntity 检查对象
   */
  private void updateValidation(SchemeDisplayEntity displayEntity) {
    Validate.notBlank(displayEntity.getId(), "陈列方案ID不能为空");
    displayEntity.getProductList().forEach(entity -> {
      entity.setId(null);
      entity.setDisplayId(displayEntity.getId());
      entity.setTenantCode(displayEntity.getTenantCode());
      Validate.isTrue(Objects.nonNull(entity.getSurfaceNumber())
          && entity.getSurfaceNumber().compareTo(BigDecimal.ZERO) > 0, "最低陈列面数数据错误");
      Validate.notBlank(entity.getProductCode(), "缺失陈列产品编码");
    });
  }
}
