package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayRequireRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayRequireService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 方案要求表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-08 14:56:23
 */
@Slf4j
@Service("schemeDisplayRequireService")
public class SchemeDisplayRequireServiceImpl implements SchemeDisplayRequireService {

  @Autowired
  private SchemeDisplayRequireRepository schemeDisplayRequireRepository;

  @Override
  @Transactional
  public void update(SchemeDisplayEntity displayEntity) {
    this.updateValidation(displayEntity);
    this.schemeDisplayRequireRepository.saveBatch(displayEntity.getRequireList());
  }

  /**
   * 在修改SchemeDisplayRequire模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param displayEntity 检查对象
   */
  private void updateValidation(SchemeDisplayEntity displayEntity) {
    Validate.notBlank(displayEntity.getId(), "陈列方案ID不能为空");
    displayEntity.getRequireList().forEach(entity -> {
      entity.setId(null);
      entity.setDisplayId(displayEntity.getId());
      entity.setTenantCode(displayEntity.getTenantCode());
      Validate.notBlank(entity.getRequireCode(), "缺失陈列要求编码");
      entity.setSortIndex(displayEntity.getRequireList().indexOf(entity) + 1);
    });
  }
}
