package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayEntity;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeDisplayConditionModel;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayProductRepository;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayRepository;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayRequireRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayProductService;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayRequireService;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 陈列方案表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-08 14:11:49
 */
@Slf4j
@Service("schemeDisplayService")
public class SchemeDisplayServiceImpl implements SchemeDisplayService {

  @Autowired
  private SchemeDisplayRepository schemeDisplayRepository;
  @Autowired
  private SchemeDisplayProductRepository schemeDisplayProductRepository;
  @Autowired
  private SchemeDisplayRequireRepository schemeDisplayRequireRepository;
  @Autowired
  private SchemeDisplayProductService schemeDisplayProductService;
  @Autowired
  private SchemeDisplayRequireService schemeDisplayRequireService;

  @Override
  @Transactional
  public SchemeDisplayEntity update(SchemeDisplayEntity entity) {
    this.updateValidation(entity);
    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    SchemeDisplayConditionModel conditionModel = new SchemeDisplayConditionModel();
    conditionModel.setTenantCode(TenantUtils.getTenantCode());
    conditionModel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    conditionModel.setSchemeCodes(Sets.newHashSet(entity.getSchemeCode()));
    List<SchemeDisplayEntity> entities = this.schemeDisplayRepository.findBySchemeDisplayConditionModel(conditionModel);
    if (!CollectionUtils.isEmpty(entities)) {
      Set<String> displayIds = entities.stream().map(SchemeDisplayEntity::getId).collect(Collectors.toSet());
      this.schemeDisplayRepository.removeByIds(displayIds);
      this.schemeDisplayProductRepository.deleteByDisplayIds(displayIds);
      this.schemeDisplayRequireRepository.deleteByDisplayIds(displayIds);
    }
    this.schemeDisplayRepository.save(entity);
    this.schemeDisplayProductService.update(entity);
    this.schemeDisplayRequireService.update(entity);
    return entity;
  }

  @Override
  @Transactional
  public void deleteBatch(List<String> schemeCodes) {
    this.schemeDisplayRepository.updateDelFlagBySchemeCodes(schemeCodes, TenantUtils.getTenantCode());
  }

  @Override
  @Transactional
  public void enableBatch(List<String> schemeCodes) {
    this.schemeDisplayRepository.updateEnableStatusBySchemeCodes(schemeCodes, EnableStatusEnum.ENABLE, TenantUtils.getTenantCode());
  }

  @Override
  @Transactional
  public void disableBatch(List<String> schemeCodes) {
    this.schemeDisplayRepository.updateEnableStatusBySchemeCodes(schemeCodes, EnableStatusEnum.DISABLE, TenantUtils.getTenantCode());
  }

  /**
   * 在修改SchemeOrdinary模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param entity 检查对象
   */
  private void updateValidation(SchemeDisplayEntity entity) {
    Validate.notNull(entity, "进行当前操作时，信息对象必须传入!");
    entity.setId(null);
    entity.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(entity.getSchemeCode(), "缺失方案编码");
    Validate.isTrue(!CollectionUtils.isEmpty(entity.getProductList()), "缺失陈列商品");
    Validate.isTrue(!CollectionUtils.isEmpty(entity.getRequireList()), "缺失陈列要求");
  }
}
