package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeFileRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeFileService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 方案文件表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-05 14:32:19
 */
@Slf4j
@Service("schemeFileService")
public class SchemeFileServiceImpl implements SchemeFileService {

  @Autowired
  private SchemeFileRepository schemeFileRepository;

  @Override
  @Transactional
  public void update(SchemeEntity schemeEntity) {
    Validate.notBlank(schemeEntity.getId(), "方案ID不能为空");
    this.schemeFileRepository.deleteBySchemeId(schemeEntity.getId());
    if (CollectionUtils.isEmpty(schemeEntity.getFileList())) {
      return;
    }
    this.updateValidation(schemeEntity);
    this.schemeFileRepository.saveBatch(schemeEntity.getFileList());
  }

  /**
   * 在修改SchemeFile模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param schemeEntity 检查对象
   */
  private void updateValidation(SchemeEntity schemeEntity) {
    schemeEntity.getFileList().forEach(entity -> {
      entity.setId(null);
      entity.setSchemeId(schemeEntity.getId());
      entity.setTenantCode(schemeEntity.getTenantCode());
      entity.setSortIndex(schemeEntity.getFileList().indexOf(entity) + 1);
      Validate.notBlank(entity.getFileCode(), "缺失文件唯一识别号");
    });
  }
}
