package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeStoreTypeRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeStoreTypeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 方案门店类型表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-05 14:32:21
 */
@Slf4j
@Service("schemeStoreTypeService")
public class SchemeStoreTypeServiceImpl implements SchemeStoreTypeService {

  @Autowired
  private SchemeStoreTypeRepository schemeStoreTypeRepository;

  @Override
  @Transactional
  public void update(SchemeEntity schemeEntity) {
    this.updateValidation(schemeEntity);
    this.schemeStoreTypeRepository.deleteBySchemeId(schemeEntity.getId());
    this.schemeStoreTypeRepository.saveBatch(schemeEntity.getStoreTypeList());
  }

  /**
   * 在修改SchemeStoreType模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param schemeEntity 检查对象
   */
  private void updateValidation(SchemeEntity schemeEntity) {
    Validate.notBlank(schemeEntity.getId(), "方案ID不能为空");
    schemeEntity.getStoreTypeList().forEach(entity -> {
      entity.setId(null);
      entity.setSchemeId(schemeEntity.getId());
      entity.setTenantCode(schemeEntity.getTenantCode());
      Validate.notBlank(entity.getStoreType(), "缺失方案门店类型");
    });
  }
}
