package com.biz.crm.sfa.business.action.scheme.local.service.internal;


import com.biz.crm.sfa.business.action.scheme.sdk.register.SchemeRegister;
import com.biz.crm.sfa.business.action.scheme.sdk.service.SchemeTypeVoService;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeTypeVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 方案类型vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/8/8
 */
@Slf4j
@Service
public class SchemeTypeVoServiceImpl implements SchemeTypeVoService {

  @Autowired(required = false)
  private List<SchemeRegister> registers;

  @Override
  public List<SchemeTypeVo> findAll() {
    if (CollectionUtils.isEmpty(registers)) {
      return Lists.newLinkedList();
    }
    return this.registers.stream().map(register -> {
      SchemeTypeVo typeVo = new SchemeTypeVo();
      typeVo.setTypeKey(register.getTypeKey());
      typeVo.setTypeName(register.getTypeName());
      return typeVo;
    }).collect(Collectors.toList());
  }
}
