package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.level.sdk.service.PositionLevelVoService;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeConditionModel;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeRepository;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionSelectPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemePageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.enums.SchemeScopeType;
import com.biz.crm.sfa.business.action.scheme.sdk.register.SchemeRegister;
import com.biz.crm.sfa.business.action.scheme.sdk.service.SchemeVoService;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeScopeVo;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 方案vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/7/29
 */
@Slf4j
@Service
public class SchemeVoServiceImpl implements SchemeVoService {

  @Autowired
  private SchemeRepository schemeRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private List<SchemeRegister> registers;
  @Autowired
  private OrgVoService orgVoService;
  @Autowired
  private PositionLevelVoService positionLevelVoService;
  @Autowired
  private UserPositionVoService userPositionVoService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private PositionVoService positionVoService;
  @Autowired
  private OrgPositionVoService orgPositionVoService;

  @Override
  public Page<SchemeVo> findByConditions(Pageable pageable, SchemePageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new SchemePageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    Page<SchemeEntity> entityPage = this.schemeRepository.findByConditions(pageable, dto);
    Page<SchemeVo> pageResult = new Page<>(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return pageResult;
    }
    pageResult.setRecords((List<SchemeVo>) this.nebulaToolkitService.copyCollectionByWhiteList(entityPage.getRecords(), SchemeEntity.class
        , SchemeVo.class, HashSet.class, ArrayList.class));
    return pageResult;
  }

  @Override
  public Page<SchemeVo> findBySchemeActionSelectPageDto(Pageable pageable, SchemeActionSelectPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new SchemeActionSelectPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    dto.setNowDate(new Date());
    this.buildPermissionInfo(dto);
    Page<SchemeEntity> entityPage = this.schemeRepository.findBySchemeActionSelectPageDto(pageable, dto);
    Page<SchemeVo> pageResult = new Page<>(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return pageResult;
    }
    pageResult.setRecords((List<SchemeVo>) this.nebulaToolkitService.copyCollectionByWhiteList(entityPage.getRecords(), SchemeEntity.class
        , SchemeVo.class, HashSet.class, ArrayList.class));
    return pageResult;
  }

  @Override
  public SchemeVo findById(String id) {
    if (Objects.isNull(id)) {
      return null;
    }
    SchemeConditionModel model = new SchemeConditionModel();
    model.setIds(Sets.newHashSet(id));
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    List<SchemeEntity> entities = this.schemeRepository.findBySchemeConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    SchemeVo schemeVo = this.nebulaToolkitService.copyObjectByBlankList(entities.get(0), SchemeVo.class, HashSet.class, ArrayList.class);
    this.buildScopeName(schemeVo);
    this.buildSpecificJson(schemeVo);
    return schemeVo;
  }

  @Override
  public SchemeVo findBySchemeCode(String schemeCode) {
    if (StringUtils.isBlank(schemeCode)) {
      return null;
    }
    SchemeConditionModel model = new SchemeConditionModel();
    model.setSchemeCodes(Sets.newHashSet(schemeCode));
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    List<SchemeEntity> entities = this.schemeRepository.findBySchemeConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    SchemeVo actionOrdinaryVo = this.nebulaToolkitService.copyObjectByBlankList(entities.get(0), SchemeVo.class, HashSet.class, ArrayList.class);
    this.buildScopeName(actionOrdinaryVo);
    this.buildSpecificJson(actionOrdinaryVo);
    return actionOrdinaryVo;
  }

  @Override
  public List<SchemeVo> findBySchemeCodes(Set<String> schemeCodes) {
    if (CollectionUtils.isEmpty(schemeCodes)) {
      return Lists.newLinkedList();
    }
    SchemeConditionModel model = new SchemeConditionModel();
    model.setSchemeCodes(schemeCodes);
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    List<SchemeEntity> entities = this.schemeRepository.findBySchemeConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    return (List<SchemeVo>) this.nebulaToolkitService.copyCollectionByBlankList(entities, SchemeEntity.class
        , SchemeVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 分页查询权限条件封装
   *
   * @param dto 分页参数dto
   */
  private void buildPermissionInfo(SchemeActionSelectPageDto dto) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    List<UserPositionVo> userPositionList = this.userPositionVoService.findByUserName(TenantUtils.getTenantCode(), loginDetails.getAccount());
    if (CollectionUtils.isEmpty(userPositionList)) {
      return;
    }
    Set<String> positionCodes = userPositionList.stream().map(UserPositionVo::getPositionCode).collect(Collectors.toSet());
    List<PositionVo> positionList = this.positionVoService.findByIdsOrCodes(Lists.newLinkedList(), Lists.newArrayList(positionCodes));
    if (CollectionUtils.isEmpty(positionList)) {
      return;
    }
    dto.setPermissionPositionLevelCodes(positionList.stream().map(PositionVo::getPositionLevelCode).collect(Collectors.toSet()));
    List<OrgPositionVo> orgPositionList = this.orgPositionVoService.findByPositionCodes(Lists.newArrayList(positionCodes));
    if (CollectionUtils.isEmpty(orgPositionList)) {
      return;
    }
    dto.setPermissionOrgCodes(orgPositionList.stream().map(OrgPositionVo::getOrgCode).collect(Collectors.toSet()));
  }

  /**
   * 封装方案实现模块特定方案信息
   *
   * @param vo 方案Vo
   */
  private void buildSpecificJson(SchemeVo vo) {
    if (CollectionUtils.isEmpty(registers)) {
      return;
    }
    this.registers.forEach(register -> {
      if (vo.getTypeKey().equals(register.getTypeKey())) {
        vo.setSpecificJson(register.onRequestBySchemeCode(vo.getSchemeCode()));
      }
    });
  }

  /**
   * 封装方案范围名称信息
   *
   * @param vo 方案Vo
   */
  private void buildScopeName(SchemeVo vo) {
    Set<String> orgCodes = Sets.newHashSet();
    Set<String> positionLevelCodes = Sets.newHashSet();
    vo.getScopeList().forEach(scopeVo -> {
      if (SchemeScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
        orgCodes.add(scopeVo.getScopeCode());
      }
      if (SchemeScopeType.POSITION_LEVEL.getDictCode().equals(scopeVo.getScopeType())) {
        positionLevelCodes.add(scopeVo.getScopeCode());
      }
    });
    Map<String, OrgVo> orgMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(orgCodes)) {
      List<OrgVo> orgList = this.orgVoService.findByOrgCodes(Lists.newArrayList(orgCodes));
      if (!CollectionUtils.isEmpty(orgList)) {
        orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (a, b) -> a));
      }
    }
    Map<String, PositionLevelVo> positionLevelMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(positionLevelCodes)) {
      List<PositionLevelVo> positionLevelList = this.positionLevelVoService.findByIdsOrCodes(Lists.newLinkedList(), Lists.newArrayList(positionLevelCodes));
      if (!CollectionUtils.isEmpty(positionLevelList)) {
        positionLevelMap = positionLevelList.stream().collect(Collectors.toMap(PositionLevelVo::getPositionLevelCode, t -> t, (a, b) -> a));
      }
    }
    for (SchemeScopeVo scopeVo : vo.getScopeList()) {
      if (SchemeScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
        scopeVo.setScopeName(orgMap.getOrDefault(scopeVo.getScopeCode(), new OrgVo()).getOrgName());
      }
      if (SchemeScopeType.POSITION_LEVEL.getDictCode().equals(scopeVo.getScopeType())) {
        scopeVo.setScopeName(positionLevelMap.getOrDefault(scopeVo.getScopeCode(), new PositionLevelVo()).getPositionLevelName());
      }
    }
  }
}
