/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeService;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/scheme/scheme"})
@Api(tags={"\u65b9\u6848: Scheme: \u65b9\u6848\u7ba1\u7406"})
public class SchemeController {
    private static final Logger log = LoggerFactory.getLogger(SchemeController.class);
    @Autowired
    private SchemeService schemeService;

    @ApiOperation(value="\u65b0\u589e\u65b9\u6848")
    @PostMapping(value={""})
    public Result<SchemeEntity> create(@RequestBody SchemeDto dto) {
        try {
            return Result.ok((Object)((Object)this.schemeService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u65b9\u6848\u4fe1\u606f")
    @PatchMapping(value={""})
    public Result<SchemeEntity> update(@RequestBody SchemeDto dto) {
        try {
            return Result.ok((Object)((Object)this.schemeService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.schemeService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result enableBatch(@RequestBody List<String> ids) {
        try {
            this.schemeService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result disableBatch(@RequestBody List<String> ids) {
        try {
            this.schemeService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

