/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.register;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayEntity;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeDisplayConditionModel;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayService;
import com.biz.crm.sfa.business.action.scheme.sdk.register.SchemeRegister;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeDisplayProductVo;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeDisplayVo;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class SchemeDisplayRegister
implements SchemeRegister {
    @Autowired
    private SchemeDisplayService schemeDisplayService;
    @Autowired
    private SchemeDisplayRepository schemeDisplayRepository;
    @Autowired
    private ProductVoService productVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public String getTypeKey() {
        return "scheme_display";
    }

    public String getTypeName() {
        return "\u9648\u5217\u65b9\u6848";
    }

    @Transactional
    public void onCreate(SchemeVo vo) {
        if (!vo.getTypeKey().equals(this.getTypeKey())) {
            return;
        }
        Validate.notNull((Object)vo.getSpecificJson(), (String)"\u7f3a\u5931\u9648\u5217\u4fe1\u606f", (Object[])new Object[0]);
        SchemeDisplayEntity schemeDisplayEntity = (SchemeDisplayEntity)((Object)JsonUtils.json2Obj((String)vo.getSpecificJson().toJSONString(), SchemeDisplayEntity.class));
        schemeDisplayEntity.setSchemeCode(vo.getSchemeCode());
        this.schemeDisplayService.update(schemeDisplayEntity);
    }

    @Transactional
    public void onUpdate(SchemeVo oldVo, SchemeVo newVo) {
        if (!newVo.getTypeKey().equals(this.getTypeKey()) || !oldVo.getTypeKey().equals(this.getTypeKey())) {
            return;
        }
        Validate.notNull((Object)newVo.getSpecificJson(), (String)"\u7f3a\u5931\u9648\u5217\u4fe1\u606f", (Object[])new Object[0]);
        SchemeDisplayEntity schemeDisplayEntity = (SchemeDisplayEntity)((Object)JsonUtils.json2Obj((String)newVo.getSpecificJson().toJSONString(), SchemeDisplayEntity.class));
        schemeDisplayEntity.setSchemeCode(newVo.getSchemeCode());
        this.schemeDisplayService.update(schemeDisplayEntity);
    }

    @Transactional
    public void onDisable(List<SchemeVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        List<String> schemeCodes = voList.stream().filter(schemeVo -> schemeVo.getTypeKey().equals(this.getTypeKey())).map(SchemeVo::getSchemeCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(schemeCodes)) {
            return;
        }
        this.schemeDisplayService.disableBatch(schemeCodes);
    }

    @Transactional
    public void onEnable(List<SchemeVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        List<String> schemeCodes = voList.stream().filter(schemeVo -> schemeVo.getTypeKey().equals(this.getTypeKey())).map(SchemeVo::getSchemeCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(schemeCodes)) {
            return;
        }
        this.schemeDisplayService.enableBatch(schemeCodes);
    }

    @Transactional
    public void onDelete(List<SchemeVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        List<String> schemeCodes = voList.stream().filter(schemeVo -> schemeVo.getTypeKey().equals(this.getTypeKey())).map(SchemeVo::getSchemeCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(schemeCodes)) {
            return;
        }
        this.schemeDisplayService.deleteBatch(schemeCodes);
    }

    public JSONObject onRequestBySchemeCode(String schemeCode) {
        SchemeDisplayConditionModel conditionModel = new SchemeDisplayConditionModel();
        conditionModel.setTenantCode(TenantUtils.getTenantCode());
        conditionModel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        conditionModel.setSchemeCodes(Sets.newHashSet((Object[])new String[]{schemeCode}));
        List<SchemeDisplayEntity> entities = this.schemeDisplayRepository.findBySchemeDisplayConditionModel(conditionModel);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        SchemeDisplayVo schemeDisplayVo = (SchemeDisplayVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entities.get(0), SchemeDisplayVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)schemeDisplayVo.getProductList())) {
            Set productCodes = schemeDisplayVo.getProductList().stream().map(SchemeDisplayProductVo::getProductCode).collect(Collectors.toSet());
            List productList = this.productVoService.findDetailsByIdsOrProductCodes((List)Lists.newArrayList(), (List)Lists.newArrayList(productCodes));
            if (!CollectionUtils.isEmpty((Collection)productList)) {
                Map<String, ProductVo> productMap = productList.stream().collect(Collectors.toMap(ProductVo::getProductCode, t -> t, (a, b) -> a));
                schemeDisplayVo.getProductList().forEach(displayProductVo -> {
                    ProductVo productVo = productMap.getOrDefault(displayProductVo.getProductCode(), new ProductVo());
                    displayProductVo.setProductLevelCode(productVo.getProductLevelCode());
                    displayProductVo.setProductName(productVo.getProductName());
                    displayProductVo.setProductLevelName(productVo.getProductLevelName());
                });
            }
        }
        return JsonUtils.toJSONObject((Object)schemeDisplayVo);
    }
}

