/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeActionEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeActionRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeActionService;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionDto;
import com.biz.crm.sfa.business.action.scheme.sdk.enums.SchemeActionStatus;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="schemeActionService")
public class SchemeActionServiceImpl
implements SchemeActionService {
    private static final Logger log = LoggerFactory.getLogger(SchemeActionServiceImpl.class);
    @Autowired
    private SchemeActionRepository schemeActionRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private ProcessBusinessService processBusinessService;
    @Autowired
    private ProcessBusinessMappingService processBusinessMappingService;

    @Override
    @Transactional
    public SchemeActionEntity create(SchemeActionDto dto) {
        this.createValidation(dto);
        SchemeActionEntity entity = (SchemeActionEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, SchemeActionEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setActionStatus(SchemeActionStatus.NORMAL.getDictCode());
        this.schemeActionRepository.save((Object)entity);
        if (Boolean.TRUE.equals(dto.getSubmitProcess())) {
            this.commitProcess(dto);
        }
        return entity;
    }

    @Override
    @Transactional
    public SchemeActionEntity update(SchemeActionDto dto) {
        this.updateValidation(dto);
        SchemeActionEntity actionEntity = (SchemeActionEntity)((Object)this.schemeActionRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)actionEntity), (String)"\u65b9\u6848\u6d3b\u52a8\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)actionEntity.getActionCode().equals(dto.getActionCode()), (String)"\u65b9\u6848\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
        businessMappingDto.setBusinessCode("scheme_action");
        businessMappingDto.setBusinessNo(dto.getActionCode());
        ProcessBusinessMappingVo businessMappingVo = this.processBusinessMappingService.findSignalByConditions(businessMappingDto);
        Validate.isTrue((Objects.isNull(businessMappingVo) || ProcessStatusEnum.REJECT.getDictCode().equals(businessMappingVo.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(businessMappingVo.getProcessStatus()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u5ba1\u6279\u72b6\u6001\u65b9\u6848\u6d3b\u52a8\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        SchemeActionEntity updateEntity = (SchemeActionEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, SchemeActionEntity.class, HashSet.class, ArrayList.class, new String[0]));
        updateEntity.setActionStatus(SchemeActionStatus.NORMAL.getDictCode());
        this.schemeActionRepository.updateById((Object)updateEntity);
        if (Boolean.TRUE.equals(dto.getSubmitProcess())) {
            this.commitProcess(dto);
        }
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.schemeActionRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.schemeActionRepository.updateDelFlagByIds(ids);
    }

    @Override
    @Transactional
    public void closeBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.schemeActionRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5173\u95ed\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.schemeActionRepository.updateActionStatusByIds(ids, SchemeActionStatus.CLOSED);
    }

    private void commitProcess(SchemeActionDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(dto.getActionCode());
        processBusiness.setBusinessCode("scheme_action");
        this.processBusinessService.processStart(processBusiness);
    }

    private void createValidation(SchemeActionDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setActionCode((String)this.generateCodeService.generateCode("SAC", 1).get(0));
        Validate.notBlank((CharSequence)dto.getSchemeCode(), (String)"\u7f3a\u5931\u65b9\u6848\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getActionName(), (String)"\u7f3a\u5931\u6d3b\u52a8\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getExchangeTypeKey(), (String)"\u7f3a\u5931\u5151\u6362\u65b9\u5f0f\u7c7b\u578bkey", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getActionStartDate(), (String)"\u7f3a\u5931\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getActionEndDate(), (String)"\u7f3a\u5931\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOaAccount(), (String)"\u7f3a\u5931OA\u6838\u9500\u53f7", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getActionCost()) && dto.getActionCost().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u8d39\u7528\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getBoxCost()) && dto.getBoxCost().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u5355\u7bb1\u6210\u672c\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getPlanSales()) && dto.getPlanSales().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8ba1\u5212\u9500\u91cf\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getPlanStoreQuantity()) && dto.getPlanStoreQuantity().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8ba1\u5212\u6295\u5165\u95e8\u5e97\u6570\u91cf\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((dto.getActionStartDate().getTime() < dto.getActionEndDate().getTime() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Date nowDate = new Date();
        Validate.isTrue((nowDate.getTime() < dto.getActionEndDate().getTime() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
    }

    private void updateValidation(SchemeActionDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSchemeCode(), (String)"\u7f3a\u5931\u65b9\u6848\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getActionCode(), (String)"\u7f3a\u5931\u6d3b\u52a8\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getActionName(), (String)"\u7f3a\u5931\u6d3b\u52a8\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getExchangeTypeKey(), (String)"\u7f3a\u5931\u5151\u6362\u65b9\u5f0f\u7c7b\u578bkey", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getActionStartDate(), (String)"\u7f3a\u5931\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getActionEndDate(), (String)"\u7f3a\u5931\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOaAccount(), (String)"\u7f3a\u5931OA\u6838\u9500\u53f7", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getActionCost()) && dto.getActionCost().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u8d39\u7528\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getBoxCost()) && dto.getBoxCost().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u5355\u7bb1\u6210\u672c\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getPlanSales()) && dto.getPlanSales().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8ba1\u5212\u9500\u91cf\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getPlanStoreQuantity()) && dto.getPlanStoreQuantity().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8ba1\u5212\u6295\u5165\u95e8\u5e97\u6570\u91cf\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((dto.getActionStartDate().getTime() < dto.getActionEndDate().getTime() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Date nowDate = new Date();
        Validate.isTrue((nowDate.getTime() < dto.getActionEndDate().getTime() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
    }
}

