/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeActionConditionModel;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeActionVoRepository;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.service.SchemeActionVoService;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeActionVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SchemeActionVoServiceImpl
implements SchemeActionVoService {
    private static final Logger log = LoggerFactory.getLogger(SchemeActionVoServiceImpl.class);
    @Autowired
    private SchemeActionVoRepository schemeActionVoRepository;
    @Autowired
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public Page<SchemeActionVo> findByConditions(Pageable pageable, SchemeActionPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (SchemeActionPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new SchemeActionPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.schemeActionVoRepository.findByConditions(pageable, dto);
    }

    public SchemeActionVo findById(String id) {
        if (Objects.isNull(id)) {
            return null;
        }
        SchemeActionConditionModel model = new SchemeActionConditionModel();
        model.setIds(Sets.newHashSet((Object[])new String[]{id}));
        model.setTenantCode(TenantUtils.getTenantCode());
        model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<SchemeActionVo> schemeActions = this.schemeActionVoRepository.findBySchemeActionConditionModel(model);
        if (CollectionUtils.isEmpty(schemeActions)) {
            return null;
        }
        SchemeActionVo schemeActionVo = schemeActions.get(0);
        ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
        businessMappingDto.setBusinessCode("scheme_action");
        businessMappingDto.setBusinessNo(schemeActionVo.getActionCode());
        ProcessBusinessMappingVo businessMappingVo = this.processBusinessMappingService.findSignalByConditions(businessMappingDto);
        if (Objects.nonNull(businessMappingVo)) {
            schemeActionVo.setProcessBusiness((ProcessBusinessVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)businessMappingVo, ProcessBusinessVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return schemeActionVo;
    }
}

