/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayProductRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayProductService;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="schemeDisplayProductService")
public class SchemeDisplayProductServiceImpl
implements SchemeDisplayProductService {
    private static final Logger log = LoggerFactory.getLogger(SchemeDisplayProductServiceImpl.class);
    @Autowired
    private SchemeDisplayProductRepository schemeDisplayProductRepository;

    @Override
    @Transactional
    public void update(SchemeDisplayEntity displayEntity) {
        this.updateValidation(displayEntity);
        this.schemeDisplayProductRepository.saveBatch(displayEntity.getProductList());
    }

    private void updateValidation(SchemeDisplayEntity displayEntity) {
        Validate.notBlank((CharSequence)displayEntity.getId(), (String)"\u9648\u5217\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        displayEntity.getProductList().forEach(entity -> {
            entity.setId(null);
            entity.setDisplayId(displayEntity.getId());
            entity.setTenantCode(displayEntity.getTenantCode());
            Validate.isTrue((Objects.nonNull(entity.getSurfaceNumber()) && entity.getSurfaceNumber().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6700\u4f4e\u9648\u5217\u9762\u6570\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)entity.getProductCode(), (String)"\u7f3a\u5931\u9648\u5217\u4ea7\u54c1\u7f16\u7801", (Object[])new Object[0]);
        });
    }
}

