/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayRequireRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayRequireService;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="schemeDisplayRequireService")
public class SchemeDisplayRequireServiceImpl
implements SchemeDisplayRequireService {
    private static final Logger log = LoggerFactory.getLogger(SchemeDisplayRequireServiceImpl.class);
    @Autowired
    private SchemeDisplayRequireRepository schemeDisplayRequireRepository;

    @Override
    @Transactional
    public void update(SchemeDisplayEntity displayEntity) {
        this.updateValidation(displayEntity);
        this.schemeDisplayRequireRepository.saveBatch(displayEntity.getRequireList());
    }

    private void updateValidation(SchemeDisplayEntity displayEntity) {
        Validate.notBlank((CharSequence)displayEntity.getId(), (String)"\u9648\u5217\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        displayEntity.getRequireList().forEach(entity -> {
            entity.setId(null);
            entity.setDisplayId(displayEntity.getId());
            entity.setTenantCode(displayEntity.getTenantCode());
            Validate.notBlank((CharSequence)entity.getRequireCode(), (String)"\u7f3a\u5931\u9648\u5217\u8981\u6c42\u7f16\u7801", (Object[])new Object[0]);
            entity.setSortIndex(displayEntity.getRequireList().indexOf(entity) + 1);
        });
    }
}

