/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayEntity;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeDisplayConditionModel;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayProductRepository;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayRepository;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeDisplayRequireRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayProductService;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayRequireService;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeDisplayService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="schemeDisplayService")
public class SchemeDisplayServiceImpl
implements SchemeDisplayService {
    private static final Logger log = LoggerFactory.getLogger(SchemeDisplayServiceImpl.class);
    @Autowired
    private SchemeDisplayRepository schemeDisplayRepository;
    @Autowired
    private SchemeDisplayProductRepository schemeDisplayProductRepository;
    @Autowired
    private SchemeDisplayRequireRepository schemeDisplayRequireRepository;
    @Autowired
    private SchemeDisplayProductService schemeDisplayProductService;
    @Autowired
    private SchemeDisplayRequireService schemeDisplayRequireService;

    @Override
    @Transactional
    public SchemeDisplayEntity update(SchemeDisplayEntity entity) {
        this.updateValidation(entity);
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        SchemeDisplayConditionModel conditionModel = new SchemeDisplayConditionModel();
        conditionModel.setTenantCode(TenantUtils.getTenantCode());
        conditionModel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        conditionModel.setSchemeCodes(Sets.newHashSet((Object[])new String[]{entity.getSchemeCode()}));
        List<SchemeDisplayEntity> entities = this.schemeDisplayRepository.findBySchemeDisplayConditionModel(conditionModel);
        if (!CollectionUtils.isEmpty(entities)) {
            Set<String> displayIds = entities.stream().map(UuidEntity::getId).collect(Collectors.toSet());
            this.schemeDisplayRepository.removeByIds(displayIds);
            this.schemeDisplayProductRepository.deleteByDisplayIds(displayIds);
            this.schemeDisplayRequireRepository.deleteByDisplayIds(displayIds);
        }
        this.schemeDisplayRepository.save((Object)entity);
        this.schemeDisplayProductService.update(entity);
        this.schemeDisplayRequireService.update(entity);
        return entity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> schemeCodes) {
        this.schemeDisplayRepository.updateDelFlagBySchemeCodes(schemeCodes, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void enableBatch(List<String> schemeCodes) {
        this.schemeDisplayRepository.updateEnableStatusBySchemeCodes(schemeCodes, EnableStatusEnum.ENABLE, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void disableBatch(List<String> schemeCodes) {
        this.schemeDisplayRepository.updateEnableStatusBySchemeCodes(schemeCodes, EnableStatusEnum.DISABLE, TenantUtils.getTenantCode());
    }

    private void updateValidation(SchemeDisplayEntity entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        entity.setId(null);
        entity.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)entity.getSchemeCode(), (String)"\u7f3a\u5931\u65b9\u6848\u7f16\u7801", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(entity.getProductList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u9648\u5217\u5546\u54c1", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(entity.getRequireList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u9648\u5217\u8981\u6c42", (Object[])new Object[0]);
    }
}

