/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeFileRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeFileService;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="schemeFileService")
public class SchemeFileServiceImpl
implements SchemeFileService {
    private static final Logger log = LoggerFactory.getLogger(SchemeFileServiceImpl.class);
    @Autowired
    private SchemeFileRepository schemeFileRepository;

    @Override
    @Transactional
    public void update(SchemeEntity schemeEntity) {
        Validate.notBlank((CharSequence)schemeEntity.getId(), (String)"\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.schemeFileRepository.deleteBySchemeId(schemeEntity.getId());
        if (CollectionUtils.isEmpty(schemeEntity.getFileList())) {
            return;
        }
        this.updateValidation(schemeEntity);
        this.schemeFileRepository.saveBatch(schemeEntity.getFileList());
    }

    private void updateValidation(SchemeEntity schemeEntity) {
        schemeEntity.getFileList().forEach(entity -> {
            entity.setId(null);
            entity.setSchemeId(schemeEntity.getId());
            entity.setTenantCode(schemeEntity.getTenantCode());
            entity.setSortIndex(schemeEntity.getFileList().indexOf(entity) + 1);
            Validate.notBlank((CharSequence)entity.getFileCode(), (String)"\u7f3a\u5931\u6587\u4ef6\u552f\u4e00\u8bc6\u522b\u53f7", (Object[])new Object[0]);
        });
    }
}

