/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeScopeRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeScopeService;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="schemeScopeService")
public class SchemeScopeServiceImpl
implements SchemeScopeService {
    private static final Logger log = LoggerFactory.getLogger(SchemeScopeServiceImpl.class);
    @Autowired
    private SchemeScopeRepository schemeScopeRepository;

    @Override
    @Transactional
    public void update(SchemeEntity schemeEntity) {
        this.updateValidation(schemeEntity);
        this.schemeScopeRepository.deleteBySchemeId(schemeEntity.getId());
        this.schemeScopeRepository.saveBatch(schemeEntity.getScopeList());
    }

    private void updateValidation(SchemeEntity schemeEntity) {
        Validate.notBlank((CharSequence)schemeEntity.getId(), (String)"\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        schemeEntity.getScopeList().forEach(entity -> {
            entity.setId(null);
            entity.setSchemeId(schemeEntity.getId());
            entity.setTenantCode(schemeEntity.getTenantCode());
            Validate.notBlank((CharSequence)entity.getScopeCode(), (String)"\u7f3a\u5931\u65b9\u6848\u8303\u56f4\u7f16\u7801", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)entity.getScopeType(), (String)"\u7f3a\u5931\u65b9\u6848\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
        });
    }
}

