/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeConditionModel;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeFileService;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeScopeService;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeService;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeStoreTypeService;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeDto;
import com.biz.crm.sfa.business.action.scheme.sdk.register.SchemeRegister;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="schemeService")
public class SchemeServiceImpl
implements SchemeService {
    private static final Logger log = LoggerFactory.getLogger(SchemeServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private SchemeRepository schemeRepository;
    @Autowired(required=false)
    private List<SchemeRegister> registers;
    @Autowired
    private SchemeScopeService schemeScopeService;
    @Autowired
    private SchemeFileService schemeFileService;
    @Autowired
    private SchemeStoreTypeService schemeStoreTypeService;

    @Override
    @Transactional
    public SchemeEntity create(SchemeDto dto) {
        this.createValidation(dto);
        SchemeEntity entity = (SchemeEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, SchemeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.schemeRepository.save((Object)entity);
        this.schemeScopeService.update(entity);
        this.schemeFileService.update(entity);
        this.schemeStoreTypeService.update(entity);
        if (!CollectionUtils.isEmpty(this.registers)) {
            SchemeVo vo = (SchemeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, SchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.registers.forEach(register -> register.onCreate(vo));
        }
        return entity;
    }

    @Override
    @Transactional
    public SchemeEntity update(SchemeDto dto) {
        this.updateValidation(dto);
        SchemeConditionModel model = new SchemeConditionModel();
        model.setIds(Sets.newHashSet((Object[])new String[]{dto.getId()}));
        model.setTenantCode(dto.getTenantCode());
        List<SchemeEntity> entities = this.schemeRepository.findBySchemeConditionModel(model);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u65b9\u6848\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        SchemeEntity oldEntity = entities.get(0);
        Validate.isTrue((boolean)oldEntity.getSchemeCode().equals(dto.getSchemeCode()), (String)"\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        Validate.isTrue((boolean)oldEntity.getTypeKey().equals(dto.getTypeKey()), (String)"\u65b9\u6848\u7c7b\u578b\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        Validate.isTrue((oldEntity.getSchemeStartDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7f16\u8f91\u672a\u5f00\u59cb\u65b9\u6848", (Object[])new Object[0]);
        SchemeEntity updateEntity = (SchemeEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, SchemeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.schemeRepository.updateById((Object)updateEntity);
        this.schemeScopeService.update(updateEntity);
        this.schemeFileService.update(updateEntity);
        this.schemeStoreTypeService.update(updateEntity);
        if (!CollectionUtils.isEmpty(this.registers)) {
            SchemeVo oldVo = (SchemeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)oldEntity, SchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
            SchemeVo newVo = (SchemeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)updateEntity, SchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.registers.forEach(register -> register.onUpdate(oldVo, newVo));
        }
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.schemeRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        entities.forEach(entity -> Validate.isTrue((entity.getSchemeStartDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u5220\u9664\u672a\u5f00\u59cb\u65b9\u6848", (Object[])new Object[0]));
        this.schemeRepository.updateDelFlagByIds(ids);
        if (!CollectionUtils.isEmpty(this.registers)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, SchemeEntity.class, SchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.registers.forEach(register -> register.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        SchemeConditionModel model = new SchemeConditionModel();
        model.setIds(Sets.newHashSet(ids));
        model.setTenantCode(TenantUtils.getTenantCode());
        List<SchemeEntity> entities = this.schemeRepository.findBySchemeConditionModel(model);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.schemeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (!CollectionUtils.isEmpty(this.registers)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, SchemeEntity.class, SchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.registers.forEach(register -> register.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        SchemeConditionModel model = new SchemeConditionModel();
        model.setIds(Sets.newHashSet(ids));
        model.setTenantCode(TenantUtils.getTenantCode());
        List<SchemeEntity> entities = this.schemeRepository.findBySchemeConditionModel(model);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.schemeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (!CollectionUtils.isEmpty(this.registers)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, SchemeEntity.class, SchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.registers.forEach(register -> register.onDisable(voList));
        }
    }

    private void createValidation(SchemeDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setSchemeCode((String)this.generateCodeService.generateCode("SC", 1).get(0));
        Validate.notBlank((CharSequence)dto.getSchemeName(), (String)"\u7f3a\u5931\u65b9\u6848\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTypeKey(), (String)"\u7f3a\u5931\u65b9\u6848\u7c7b\u578bkey", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSchemeStartDate(), (String)"\u7f3a\u5931\u65b9\u6848\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSchemeEndDate(), (String)"\u7f3a\u5931\u65b9\u6848\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((dto.getSchemeStartDate().getTime() < dto.getSchemeEndDate().getTime() ? 1 : 0) != 0, (String)"\u65b9\u6848\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u65b9\u6848\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Date nowDate = new Date();
        Validate.isTrue((nowDate.getTime() < dto.getSchemeEndDate().getTime() ? 1 : 0) != 0, (String)"\u65b9\u6848\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getStoreTypeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u65b9\u6848\u95e8\u5e97\u7c7b\u578b", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getScopeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u65b9\u6848\u8303\u56f4", (Object[])new Object[0]);
    }

    private void updateValidation(SchemeDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSchemeCode(), (String)"\u7f3a\u5931\u65b9\u6848\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSchemeName(), (String)"\u7f3a\u5931\u65b9\u6848\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTypeKey(), (String)"\u7f3a\u5931\u65b9\u6848\u7c7b\u578bkey", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSchemeStartDate(), (String)"\u7f3a\u5931\u65b9\u6848\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSchemeEndDate(), (String)"\u7f3a\u5931\u65b9\u6848\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((dto.getSchemeStartDate().getTime() < dto.getSchemeEndDate().getTime() ? 1 : 0) != 0, (String)"\u65b9\u6848\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u65b9\u6848\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Date nowDate = new Date();
        Validate.isTrue((nowDate.getTime() < dto.getSchemeEndDate().getTime() ? 1 : 0) != 0, (String)"\u65b9\u6848\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getStoreTypeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u65b9\u6848\u95e8\u5e97\u7c7b\u578b", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getScopeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u65b9\u6848\u8303\u56f4", (Object[])new Object[0]);
    }
}

