/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeStoreTypeRepository;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeStoreTypeService;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="schemeStoreTypeService")
public class SchemeStoreTypeServiceImpl
implements SchemeStoreTypeService {
    private static final Logger log = LoggerFactory.getLogger(SchemeStoreTypeServiceImpl.class);
    @Autowired
    private SchemeStoreTypeRepository schemeStoreTypeRepository;

    @Override
    @Transactional
    public void update(SchemeEntity schemeEntity) {
        this.updateValidation(schemeEntity);
        this.schemeStoreTypeRepository.deleteBySchemeId(schemeEntity.getId());
        this.schemeStoreTypeRepository.saveBatch(schemeEntity.getStoreTypeList());
    }

    private void updateValidation(SchemeEntity schemeEntity) {
        Validate.notBlank((CharSequence)schemeEntity.getId(), (String)"\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        schemeEntity.getStoreTypeList().forEach(entity -> {
            entity.setId(null);
            entity.setSchemeId(schemeEntity.getId());
            entity.setTenantCode(schemeEntity.getTenantCode());
            Validate.notBlank((CharSequence)entity.getStoreType(), (String)"\u7f3a\u5931\u65b9\u6848\u95e8\u5e97\u7c7b\u578b", (Object[])new Object[0]);
        });
    }
}

