/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.action.scheme.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.level.sdk.service.PositionLevelVoService;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeConditionModel;
import com.biz.crm.sfa.business.action.scheme.local.repository.SchemeRepository;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionSelectPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemePageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.enums.SchemeScopeType;
import com.biz.crm.sfa.business.action.scheme.sdk.register.SchemeRegister;
import com.biz.crm.sfa.business.action.scheme.sdk.service.SchemeVoService;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeScopeVo;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SchemeVoServiceImpl
implements SchemeVoService {
    private static final Logger log = LoggerFactory.getLogger(SchemeVoServiceImpl.class);
    @Autowired
    private SchemeRepository schemeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<SchemeRegister> registers;
    @Autowired
    private OrgVoService orgVoService;
    @Autowired
    private PositionLevelVoService positionLevelVoService;
    @Autowired
    private UserPositionVoService userPositionVoService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private PositionVoService positionVoService;
    @Autowired
    private OrgPositionVoService orgPositionVoService;

    public Page<SchemeVo> findByConditions(Pageable pageable, SchemePageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (SchemePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new SchemePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page<SchemeEntity> entityPage = this.schemeRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        pageResult.setRecords((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entityPage.getRecords(), SchemeEntity.class, SchemeVo.class, HashSet.class, ArrayList.class, new String[0]));
        return pageResult;
    }

    public Page<SchemeVo> findBySchemeActionSelectPageDto(Pageable pageable, SchemeActionSelectPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (SchemeActionSelectPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new SchemeActionSelectPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setNowDate(new Date());
        this.buildPermissionInfo(dto);
        Page<SchemeEntity> entityPage = this.schemeRepository.findBySchemeActionSelectPageDto(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        pageResult.setRecords((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entityPage.getRecords(), SchemeEntity.class, SchemeVo.class, HashSet.class, ArrayList.class, new String[0]));
        return pageResult;
    }

    public SchemeVo findById(String id) {
        if (Objects.isNull(id)) {
            return null;
        }
        SchemeConditionModel model = new SchemeConditionModel();
        model.setIds(Sets.newHashSet((Object[])new String[]{id}));
        model.setTenantCode(TenantUtils.getTenantCode());
        model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<SchemeEntity> entities = this.schemeRepository.findBySchemeConditionModel(model);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        SchemeVo schemeVo = (SchemeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entities.get(0), SchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildScopeName(schemeVo);
        this.buildSpecificJson(schemeVo);
        return schemeVo;
    }

    public SchemeVo findBySchemeCode(String schemeCode) {
        if (StringUtils.isBlank((CharSequence)schemeCode)) {
            return null;
        }
        SchemeConditionModel model = new SchemeConditionModel();
        model.setSchemeCodes(Sets.newHashSet((Object[])new String[]{schemeCode}));
        model.setTenantCode(TenantUtils.getTenantCode());
        model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<SchemeEntity> entities = this.schemeRepository.findBySchemeConditionModel(model);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        SchemeVo actionOrdinaryVo = (SchemeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entities.get(0), SchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildScopeName(actionOrdinaryVo);
        this.buildSpecificJson(actionOrdinaryVo);
        return actionOrdinaryVo;
    }

    public List<SchemeVo> findBySchemeCodes(Set<String> schemeCodes) {
        if (CollectionUtils.isEmpty(schemeCodes)) {
            return Lists.newLinkedList();
        }
        SchemeConditionModel model = new SchemeConditionModel();
        model.setSchemeCodes(schemeCodes);
        model.setTenantCode(TenantUtils.getTenantCode());
        model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<SchemeEntity> entities = this.schemeRepository.findBySchemeConditionModel(model);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, SchemeEntity.class, SchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void buildPermissionInfo(SchemeActionSelectPageDto dto) {
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        List userPositionList = this.userPositionVoService.findByUserName(TenantUtils.getTenantCode(), loginDetails.getAccount());
        if (CollectionUtils.isEmpty((Collection)userPositionList)) {
            return;
        }
        Set positionCodes = userPositionList.stream().map(UserPositionVo::getPositionCode).collect(Collectors.toSet());
        List positionList = this.positionVoService.findByIdsOrCodes((List)Lists.newLinkedList(), (List)Lists.newArrayList(positionCodes));
        if (CollectionUtils.isEmpty((Collection)positionList)) {
            return;
        }
        dto.setPermissionPositionLevelCodes(positionList.stream().map(PositionVo::getPositionLevelCode).collect(Collectors.toSet()));
        List orgPositionList = this.orgPositionVoService.findByPositionCodes((List)Lists.newArrayList(positionCodes));
        if (CollectionUtils.isEmpty((Collection)orgPositionList)) {
            return;
        }
        dto.setPermissionOrgCodes(orgPositionList.stream().map(OrgPositionVo::getOrgCode).collect(Collectors.toSet()));
    }

    private void buildSpecificJson(SchemeVo vo) {
        if (CollectionUtils.isEmpty(this.registers)) {
            return;
        }
        this.registers.forEach(register -> {
            if (vo.getTypeKey().equals(register.getTypeKey())) {
                vo.setSpecificJson(register.onRequestBySchemeCode(vo.getSchemeCode()));
            }
        });
    }

    private void buildScopeName(SchemeVo vo) {
        List positionLevelList;
        List orgList;
        HashSet orgCodes = Sets.newHashSet();
        HashSet positionLevelCodes = Sets.newHashSet();
        vo.getScopeList().forEach(scopeVo -> {
            if (SchemeScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
                orgCodes.add(scopeVo.getScopeCode());
            }
            if (SchemeScopeType.POSITION_LEVEL.getDictCode().equals(scopeVo.getScopeType())) {
                positionLevelCodes.add(scopeVo.getScopeCode());
            }
        });
        Map<Object, Object> orgMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)orgCodes) && !CollectionUtils.isEmpty((Collection)(orgList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList((Iterable)orgCodes))))) {
            orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (a, b) -> a));
        }
        Map<Object, Object> positionLevelMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)positionLevelCodes) && !CollectionUtils.isEmpty((Collection)(positionLevelList = this.positionLevelVoService.findByIdsOrCodes((List)Lists.newLinkedList(), (List)Lists.newArrayList((Iterable)positionLevelCodes))))) {
            positionLevelMap = positionLevelList.stream().collect(Collectors.toMap(PositionLevelVo::getPositionLevelCode, t -> t, (a, b) -> a));
        }
        for (SchemeScopeVo scopeVo2 : vo.getScopeList()) {
            if (SchemeScopeType.ORG.getDictCode().equals(scopeVo2.getScopeType())) {
                scopeVo2.setScopeName(orgMap.getOrDefault(scopeVo2.getScopeCode(), new OrgVo()).getOrgName());
            }
            if (!SchemeScopeType.POSITION_LEVEL.getDictCode().equals(scopeVo2.getScopeType())) continue;
            scopeVo2.setScopeName(positionLevelMap.getOrDefault(scopeVo2.getScopeCode(), new PositionLevelVo()).getPositionLevelName());
        }
    }
}

