package com.biz.crm.sfa.business.attendance.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyEntity;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceFillApplyService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillClockDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 考勤记录: AttendanceFillApply: 考勤补打卡
 *
 * @author ning.zhang
 * @date 2022/5/25
 */
@Slf4j
@RestController
@RequestMapping("/v1/attendance/attendanceFillApply")
@Api(tags = "考勤记录: AttendanceFillApply: 考勤补打卡")
public class AttendanceFillApplyController {

  @Autowired
  private AttendanceFillApplyService attendanceFillApplyService;

  /**
   * 移动端-创建补打卡申请
   *
   * @param dto 参数dto
   * @return 补打卡申请
   */
  @ApiOperation(value = "移动端-创建补打卡申请")
  @PostMapping("create")
  public Result<AttendanceFillApplyEntity> create(@RequestBody AttendanceFillClockDto dto) {
    try {
      return Result.ok(this.attendanceFillApplyService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 移动端-修改补打卡申请
   *
   * @param dto 参数dto
   * @return 补打卡申请
   */
  @ApiOperation(value = "移动端-修改补打卡申请")
  @PostMapping("update")
  public Result<AttendanceFillApplyEntity> update(@RequestBody AttendanceFillClockDto dto) {
    try {
      return Result.ok(this.attendanceFillApplyService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
