package com.biz.crm.sfa.business.attendance.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillApplyPageDto;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceFillApplyVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 考勤记录: AttendanceFillApplyVo: 考勤补打卡
 *
 * @author ning.zhang
 * @date 2022/5/25
 */
@Slf4j
@RestController
@RequestMapping("/v1/attendance/attendanceFillApply")
@Api(tags = "考勤记录: AttendanceFillApplyVo: 考勤补打卡")
public class AttendanceFillApplyVoController {

  @Autowired
  private AttendanceFillApplyVoService attendanceFillApplyVoService;

  /**
   * 移动端-补打卡申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceFillApplyVo> 补打卡申请分页信息
   */
  @ApiOperation(value = "移动端-补打卡申请分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<AttendanceFillApplyVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "AttendanceFillApplyPageDto", value = "分页Dto") AttendanceFillApplyPageDto dto) {
    try {
      return Result.ok(this.attendanceFillApplyVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过ID查询补打卡申请信息
   *
   * @param id ID
   * @return 补打卡申请信息
   */
  @ApiOperation(value = "通过ID获取补打卡申请信息")
  @GetMapping("/findById")
  public Result<AttendanceFillApplyVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      List<AttendanceFillApplyVo> list = this.attendanceFillApplyVoService.findByIds(Lists.newArrayList(id));
      return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 后台-补打卡分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceFillApplyVo> 补打卡申请分页信息
   */
  @ApiOperation(value = "后台-补打卡分页列表")
  @GetMapping("/findDetailByConditions")
  public Result<Page<AttendanceFillApplyVo>> findDetailByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "AttendanceFillApplyPageDto", value = "分页Dto") AttendanceFillApplyPageDto dto) {
    try {
      return Result.ok(this.attendanceFillApplyVoService.findDetailByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
