package com.biz.crm.sfa.business.attendance.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRecordService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillClockDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 考勤记录: AttendanceRecord: 考勤记录信息
 *
 * @author ning.zhang
 * @date 2022/5/19
 */
@Slf4j
@RestController
@RequestMapping("/v1/attendance/attendanceRecord")
@Api(tags = "考勤记录: AttendanceRecord: 考勤记录信息")
public class AttendanceRecordController {

  @Autowired
  private AttendanceRecordService attendanceRecordService;

  /**
   * 移动端-查询补打卡考勤信息
   *
   * @param dto 参数dto
   * @return 补打卡考勤信息
   */
  @ApiOperation(value = "移动端-查询补打卡考勤信息")
  @GetMapping("/findByAttendanceFillClockDto")
  public Result<List<AttendanceRecordEntity>> findByAttendanceFillClockDto(@ApiParam(name = "AttendanceFillClockDto") AttendanceFillClockDto dto) {
    try {
      return Result.ok(this.attendanceRecordService.findByAttendanceFillClockDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
