package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 补打考勤申请实体类
 *
 * @author ning.zhang
 * @date 2022/5/24
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceFillApplyEntity", description = "补打考勤申请实体类")
@Entity
@TableName("sfa_attendance_fill_apply")
@Table(name = "sfa_attendance_fill_apply", indexes = {
    @Index(name = "sfa_attendance_fill_apply_index1", columnList = "user_name"),
    @Index(name = "sfa_attendance_fill_apply_index2", columnList = "apply_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_fill_apply", comment = "补打考勤申请表")
public class AttendanceFillApplyEntity extends WorkflowFlagOpEntity {

  private static final long serialVersionUID = 7308746223011849221L;

  /**
   * 申请编码
   */
  @ApiModelProperty("申请编码")
  @Column(name = "apply_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '申请编码'")
  private String applyCode;

  /**
   * 申请原因
   */
  @ApiModelProperty("申请原因")
  @Column(name = "apply_reason", length = 512, columnDefinition = "VARCHAR(512) COMMENT '申请原因'")
  private String applyReason;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  @Column(name = "user_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '人员账号'")
  private String userName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  @Column(name = "user_real_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '人员姓名'")
  private String userRealName;



  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("申请日期(yyyy-MM-dd HH:mm:ss)")
  @Column(name = "apply_date", length = 20, columnDefinition = "VARCHAR(20) COMMENT '申请日期(yyyy-MM-dd HH:mm:ss)'")
  private String applyDate;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty("开始时间(yyyy-MM-dd)")
  @Column(name = "begin_time", length = 20, columnDefinition = "VARCHAR(20) COMMENT '开始时间(yyyy-MM-dd)'")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty("结束时间(yyyy-MM-dd)")
  @Column(name = "end_time", length = 20, columnDefinition = "VARCHAR(20) COMMENT '结束时间(yyyy-MM-dd)'")
  private String endTime;

  /**
   * 异常打卡记录ID集合
   */
  @ApiModelProperty("异常打卡记录ID集合")
  @Column(name = "record_ids", length = 4000, nullable = false, columnDefinition = "VARCHAR(4000) NOT NULL COMMENT '异常打卡记录ID集合'")
  private String recordIds;

  /**
   * 职位编码 职位编码
   */
  @Column(name = "position_code", length = 32, columnDefinition = "varchar(32) COMMENT '职位编码 职位编码'")
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称 职位名称
   */
  @Column(name = "position_name", length = 100, columnDefinition = "varchar(100) COMMENT '职位名称 职位名称'")
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 所属组织编码 所属组织编码
   */
  @Column(name = "org_code", length = 32, columnDefinition = "varchar(32) COMMENT '所属组织编码 所属组织编码'")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 所属组织名称 所属组织名称
   */
  @Column(name = "org_name", length = 100, columnDefinition = "varchar(100) COMMENT '所属组织名称 所属组织名称'")
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 申请照片
   */
  @ApiModelProperty("申请照片")
  @Transient
  @TableField(exist = false)
  private List<AttendanceFillApplyPictureEntity> pictureList;
}
