package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 补打考勤申请照片实体类
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceFillApplyPictureEntity", description = "补打考勤申请照片实体类")
@Entity
@TableName("sfa_attendance_fill_apply_picture")
@Table(name = "sfa_attendance_fill_apply_picture", indexes = {
    @Index(name = "sfa_attendance_fill_apply_picture_index1", columnList = "apply_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_fill_apply_picture", comment = "补打考勤申请照片表")
public class AttendanceFillApplyPictureEntity extends FileEntity {

  private static final long serialVersionUID = 5331395888537732516L;

  /**
   * 申请ID
   */
  @ApiModelProperty("申请ID")
  @Column(name = "apply_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '申请ID'")
  private String applyId;

}
