package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 考勤记录规则实体类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceRecordRuleEntity", description = "考勤记录规则实体类")
@Entity
@TableName("sfa_attendance_record_rule")
@Table(name = "sfa_attendance_record_rule", indexes = {
    @Index(name = "sfa_attendance_record_rule_index1", columnList = "rule_id"),
    @Index(name = "sfa_attendance_record_rule_index2", columnList = "rule_date"),
    @Index(name = "sfa_attendance_record_rule_index3", columnList = "rule_year"),
    @Index(name = "sfa_attendance_record_rule_index4", columnList = "rule_month"),
    @Index(name = "sfa_attendance_record_rule_index5", columnList = "rule_year_month"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_record_rule", comment = "考勤记录规则表")
public class AttendanceRecordRuleEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 2725411267761172801L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  @Column(name = "rule_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则ID'")
  private String ruleId;

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  @Column(name = "rule_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则编码'")
  private String ruleCode;

  /**
   * 规则名称
   */
  @ApiModelProperty("规则名称")
  @Column(name = "rule_name", length = 100, nullable = false, columnDefinition = "VARCHAR(100) NOT NULL COMMENT '规则名称'")
  private String ruleName;

  /**
   * 规则类型(static:固定时间上下班规则;free_time:自由时间上下班规则)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleType
   */
  @ApiModelProperty("规则类型(static:固定时间上下班规则;free_time:自由时间上下班规则)")
  @Column(name = "rule_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '规则类型(static:固定时间上下班规则;free_time:自由时间上下班规则)'")
  private String ruleType;

  /**
   * 打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceElectronFenceType
   */
  @ApiModelProperty("打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)")
  @Column(name = "electron_fence_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)'")
  private String electronFenceType;

  /**
   * 工作日(1:星期一;2:星期二;3:星期三;4:星期四;5:星期五;6:星期六;7:星期日)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceWorkingDayType
   */
  @ApiModelProperty("工作日(1:星期一;2:星期二;3:星期三;4:星期四;5:星期五;6:星期六;7:星期日)")
  @Column(name = "working_day", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '工作日(1:星期一;2:星期二;3:星期三;4:星期四;5:星期五;6:星期六;7:星期日)'")
  private String workingDay;

  /**
   * 是否同步节假日-节假日期间不用打卡(Y:同步;N:不同步)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否同步节假日-节假日期间不用打卡(Y:同步;N:不同步)")
  @Column(name = "sync_holiday", length = 4, nullable = false, columnDefinition = "VARCHAR(4) NOT NULL COMMENT '是否同步节假日-节假日期间不用打卡(Y:同步;N:不同步)'")
  private String syncHoliday;

  /**
   * 打卡是否需要拍照(Y:需要;N:不需要)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("打卡是否需要拍照(Y:需要;N:不需要)")
  @Column(name = "clock_photograph", length = 4, nullable = false, columnDefinition = "VARCHAR(4) NOT NULL COMMENT '打卡是否需要拍照(Y:需要;N:不需要)'")
  private String clockPhotograph;

  /**
   * 下班打卡类型(no_sign:下班不需要打卡;goto_work_required:下班需要打卡，且必须打上班卡才能打下班卡;goto_work_no_required:下班需要打卡，无需打上班卡，就能打下班卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceOffWorkClockType
   */
  @ApiModelProperty("下班打卡类型(no_sign:下班不需要打卡;goto_work_required:下班需要打卡，且必须打上班卡才能打下班卡;goto_work_no_required:下班需要打卡，无需打上班卡，就能打下班卡)")
  @Column(name = "off_work_clock_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '下班打卡类型(no_sign:下班不需要打卡;goto_work_required:下班需要打卡，且必须打上班卡才能打下班卡;goto_work_no_required:下班需要打卡，无需打上班卡，就能打下班卡)'")
  private String offWorkClockType;

  /**
   * 规则生效类型(now:立即生效;tomorrow:明日生效)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleEffectiveType
   */
  @ApiModelProperty("规则生效类型(now:立即生效;tomorrow:明日生效)")
  @Column(name = "rule_effective", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '规则生效类型(now:立即生效;tomorrow:明日生效)'")
  private String ruleEffective;

  /**
   * 非工作日模块遵守考勤规则关联信息
   */
  @ApiModelProperty("非工作日模块遵守考勤规则关联信息")
  @Column(name = "no_work_abide_info", length = 4000, columnDefinition = "VARCHAR(4000) COMMENT '非工作日模块遵守考勤规则关联信息'")
  private String noWorkAbideInfo;

  /**
   * 考勤日期(yyyy-MM-dd)
   */
  @ApiModelProperty("考勤日期(yyyy-MM-dd)")
  @Column(name = "rule_date", columnDefinition = "VARCHAR(10) COMMENT '考勤日期(yyyy-MM-dd)'")
  private String ruleDate;

  /**
   * 考勤日期(yyyy)
   */
  @ApiModelProperty("考勤日期(yyyy)")
  @Column(name = "rule_year", columnDefinition = "VARCHAR(10) COMMENT '考勤日期(yyyy)'")
  private String ruleYear;

  /**
   * 考勤日期(MM)
   */
  @ApiModelProperty("考勤日期(MM)")
  @Column(name = "rule_month", columnDefinition = "VARCHAR(10) COMMENT '考勤日期(MM)'")
  private String ruleMonth;

  /**
   * 考勤日期(yyyy-MM
   */
  @ApiModelProperty("考勤日期(yyyy-MM)")
  @Column(name = "rule_year_month", columnDefinition = "VARCHAR(10) COMMENT '考勤日期(yyyy-MM)'")
  private String ruleYearMonth;

  /**
   * 是否工作日(Y:是;N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否工作日(Y:是;N:否)")
  @Column(name = "sign_must", length = 4, nullable = false, columnDefinition = "VARCHAR(4) NOT NULL COMMENT '是否工作日(Y:是;N:否)'")
  private String signMust;

  /**
   * 打卡或不打卡类型(workday_sign:工作日打卡;special_day_sign:特殊日期打卡,work_day_no_sign:非工作日不打卡,special_day_no_sign:特殊日期不打卡,holiday_no_sign:节假日不打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceSignOrNonType
   */
  @ApiModelProperty("打卡或不打卡类型(workday_sign:工作日打卡;special_day_sign:特殊日期打卡,work_day_no_sign:非工作日不打卡,special_day_no_sign:特殊日期不打卡,holiday_no_sign:节假日不打卡)")
  @Column(name = "sign_or_non_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT " +
      "'打卡或不打卡类型(workday_sign:工作日打卡;special_day_sign:特殊日期打卡,work_day_no_sign:非工作日不打卡,special_day_no_sign:特殊日期不打卡,holiday_no_sign:节假日不打卡)'")
  private String signOrNonType;

}
