package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 考勤规则地点实体类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceRulePlaceEntity", description = "考勤规则地点实体类")
@Entity
@TableName("sfa_attendance_rule_place")
@Table(name = "sfa_attendance_rule_place", indexes = {
    @Index(name = "sfa_attendance_rule_place_index1", columnList = "rule_id")
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_rule_place", comment = "考勤规则地点表")
public class AttendanceRulePlaceEntity extends UuidOpEntity {

  private static final long serialVersionUID = -4539209569341286727L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  @Column(name = "rule_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则ID'")
  private String ruleId;

  /**
   * 地点序号
   */
  @ApiModelProperty("地点序号")
  @Column(name = "place_no", length = 64, columnDefinition = "VARCHAR(64) COMMENT '地点序号'")
  private String placeNo;

  /**
   * 地点名称
   */
  @ApiModelProperty("地点名称")
  @Column(name = "place_name", columnDefinition = "VARCHAR(255) COMMENT '地点名称'")
  private String placeName;

  /**
   * 地点经度
   */
  @ApiModelProperty("地点经度")
  @Column(name = "place_longitude", columnDefinition = "decimal(12,8) COMMENT '地点经度'")
  private BigDecimal placeLongitude;

  /**
   * 地点纬度
   */
  @ApiModelProperty("地点纬度")
  @Column(name = "place_latitude", columnDefinition = "decimal(12,8) COMMENT '地点纬度'")
  private BigDecimal placeLatitude;

  /**
   * 打卡类型(on_and_off_work:上下班打卡,on_work:上班打卡,off_work:下班打卡)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @ApiModelProperty("打卡类型(on_and_off_work:上下班打卡,on_work:上班打卡,off_work:下班打卡)")
  @Column(name = "clock_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '打卡类型(on_and_off_work:上下班打卡,on_work:上班打卡,off_work:下班打卡)'")
  private String clockType;

  /**
   * 地点范围((100:100米,300:300米,500:500米))
   */
  @ApiModelProperty("地点范围((100:100米,300:300米,500:500米))")
  @Column(name = "place_range", columnDefinition = "INT(7) COMMENT '地点范围((100:100米,300:300米,500:500米))'")
  private Integer placeRange;

}
