package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * 考勤规则范围实体类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceRuleScopeEntity", description = "考勤规则范围实体类")
@Entity
@TableName("sfa_attendance_rule_scope")
@Table(name = "sfa_attendance_rule_scope", indexes = {
    @Index(name = "sfa_attendance_rule_scope_index1", columnList = "rule_id"),
    @Index(name = "sfa_attendance_rule_scope_index2", columnList = "scope_code,scope_type"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_rule_scope", comment = "考勤规则范围表")
public class AttendanceRuleScopeEntity extends UuidOpEntity {

  private static final long serialVersionUID = 250936471751664088L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  @Column(name = "rule_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则ID'")
  private String ruleId;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  @Column(name = "scope_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '范围编码'")
  private String scopeCode;

  /**
   * 范围类型(org:组织;position_level:职位级别)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType
   */
  @ApiModelProperty("范围类型(org:组织;position_level:职位级别)")
  @Column(name = "scope_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '范围类型(org:组织;position_level:职位级别)'")
  private String scopeType;

  /**
   * 是否包含下级范围编码(Y:包含;N:不包含)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否包含下级范围编码(Y:包含;N:不包含)")
  @Column(name = "contains_child", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '是否包含下级范围编码(Y:包含;N:不包含)'")
  private String containsChild;

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  @Transient
  @TableField(exist = false)
  private String ruleCode;

}
