package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 考勤规则打卡时间实体类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceRuleTimeEntity", description = "考勤规则打卡时间实体类")
@Entity
@TableName("sfa_attendance_rule_time")
@Table(name = "sfa_attendance_rule_time", indexes = {
    @Index(name = "sfa_attendance_rule_time_index1", columnList = "rule_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_rule_time", comment = "考勤规则打卡时间表")
public class AttendanceRuleTimeEntity extends UuidOpEntity {

  private static final long serialVersionUID = 250936471751664088L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  @Column(name = "rule_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则ID'")
  private String ruleId;

  /**
   * 时间段序号
   */
  @ApiModelProperty("时间段序号")
  @Column(name = "time_no", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '时间段序号'")
  private String timeNo;

  /**
   * 上班时间
   */
  @ApiModelProperty("上班时间")
  @Column(name = "on_work_time", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '上班时间'")
  private String onWorkTime;

  /**
   * 下班时间
   */
  @ApiModelProperty("下班时间")
  @Column(name = "off_work_time", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '下班时间'")
  private String offWorkTime;

  /**
   * 上班打卡开始时间
   */
  @ApiModelProperty("上班打卡开始时间")
  @Column(name = "on_work_clock_start_time", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '上班打卡开始时间'")
  private String onWorkClockStartTime;

  /**
   * 上班打卡结束时间
   */
  @ApiModelProperty("上班打卡结束时间")
  @Column(name = "on_work_clock_end_time", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '上班打卡结束时间'")
  private String onWorkClockEndTime;

  /**
   * 下班打卡开始时间
   */
  @ApiModelProperty("下班打卡开始时间")
  @Column(name = "off_work_clock_start_time", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '下班打卡开始时间'")
  private String offWorkClockStartTime;

  /**
   * 下班打卡结束时间
   */
  @ApiModelProperty("下班打卡结束时间")
  @Column(name = "off_work_clock_end_time", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '下班打卡结束时间'")
  private String offWorkClockEndTime;

}
