package com.biz.crm.sfa.business.attendance.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.sdk.dto.RuleConditionDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRulePageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤规则表的mybatis-plus接口类 {@link AttendanceRuleEntity}
 *
 * @author ning.zhang
 * @date 2022-05-05 09:43:05
 */
public interface AttendanceRuleMapper extends BaseMapper<AttendanceRuleEntity> {

  /**
   * 通过考勤规则ID集合获取考勤规则信息
   *
   * @param ids 考勤规则ID集合
   * @return 考勤规则信息
   */
  List<AttendanceRuleEntity> findByIds(@Param("ids") List<String> ids);

  /**
   * 考勤规则分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<AttendanceRuleEntity> 考勤规则分页信息
   */
  Page<AttendanceRuleEntity> findByConditions(Page<AttendanceRuleEntity> page, @Param("dto") AttendanceRulePageDto dto);

  /**
   * 多条件查询考勤规则列表
   *
   * @param dto 条件dto
   * @return 考勤规则列表
   */
  List<AttendanceRuleEntity> findByRuleConditionDto(@Param("dto") RuleConditionDto dto);

}

