package com.biz.crm.sfa.business.attendance.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 考勤补打卡申请多条件model
 *
 * @author ning.zhang
 * @date 2022/5/25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FillApplyConditionModel", description = "考勤补打卡申请多条件model")
public class FillApplyConditionModel {

  /**
   * 用户账号
   */
  @ApiModelProperty(value = "用户账号")
  private String userName;

  /**
   * 开始时间
   */
  @ApiModelProperty(value = "开始时间")
  private String beginTime;

  /**
   * 结束时间
   */
  @ApiModelProperty(value = "结束时间")
  private String endTime;

  /**
   * 排除的流程状态列表
   */
  @ApiModelProperty(value = "排除的流程状态列表")
  private List<String> excludeProcessStatusList;

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;
}
