package com.biz.crm.sfa.business.attendance.local.model;

import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 考勤规则执行model
 *
 * @author ning.zhang
 * @date 2022/5/17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RuleExecuteModel", description = "考勤规则执行model")
public class RuleExecuteModel {

  /**
   * 执行日期
   */
  @ApiModelProperty("执行日期")
  private String executeDate;

  /***
   * 考勤规则映射Map(key:规则ID, value:规则信息)
   */
  @ApiModelProperty("考勤规则映射Map(key:规则ID, value:规则信息)")
  private Map<String, AttendanceRuleEntity> ruleMap;

  /***
   * 考勤规则组织映射Map(key:规则ID, value:组织编码集合)
   */
  @ApiModelProperty("勤规则组织映射Map(key:规则ID, value:组织编码集合)")
  private Map<String, Set<String>> ruleOrgMap;

  /***
   * 考勤规则职级映射Map(key:规则ID, value:职级编码集合)
   */
  @ApiModelProperty("考勤规则职级映射Map(key:规则ID, value:职级编码集合)")
  private Map<String, Set<String>> rulePositionLevelMap;

  /***
   * 组织用户映射Map(key:组织编码, value:用户信息集合)
   */
  @ApiModelProperty("组织用户映射Map(key:组织编码, value:用户信息集合)")
  private Map<String, List<RuleExecuteUserModel>> orgUserMap;

  /***
   * 考勤规则用户映射Map(key:规则ID, value:用户信息集合)
   */
  @ApiModelProperty("考勤规则用户映射Map(key:规则ID, value:用户信息集合)")
  private Map<String, List<RuleExecuteUserModel>> ruleUserMap;
}
