package com.biz.crm.sfa.business.attendance.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 考勤规则范围多条件model
 *
 * @author ning.zhang
 * @date 2022/5/6
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RuleScopeConditionModel", description = "考勤规则范围多条件model")
public class RuleScopeConditionModel {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /***
   * 范围编码集合
   */
  @ApiModelProperty("范围编码集合")
  private List<String> scopeCodes;

  /**
   * 范围类型(org:组织;position_level:职位级别)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType
   */
  @ApiModelProperty("范围类型")
  private String scopeType;

  /**
   * 规则ID集合
   */
  @ApiModelProperty("规则ID集合")
  private List<String> ruleIds;

  /**
   * 规则编码集合
   */
  @ApiModelProperty("规则编码集合")
  private List<String> ruleCodes;
}
