package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyPictureEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceFillApplyPictureMapper;
import org.springframework.stereotype.Component;

/**
 * 补打考勤申请照片表的数据库访问类 {@link AttendanceFillApplyPictureEntity}
 *
 * @author ning.zhang
 * @date 2022-05-25 16:21:46
 */
@Component
public class AttendanceFillApplyPictureRepository extends ServiceImpl<AttendanceFillApplyPictureMapper, AttendanceFillApplyPictureEntity> {

  /**
   * 通过补打卡申请ID删除勤记录照片信息
   *
   * @param applyId 补打卡申请ID
   */
  public void deleteByApplyId(String applyId) {
    this.lambdaUpdate()
        .eq(AttendanceFillApplyPictureEntity::getApplyId, applyId)
        .remove();
  }
}
