package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceFillApplyMapper;
import com.biz.crm.sfa.business.attendance.local.model.FillApplyConditionModel;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillApplyPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 补打考勤申请表的数据库访问类 {@link AttendanceFillApplyEntity}
 *
 * @author ning.zhang
 * @date 2022-05-25 10:40:08
 */
@Component
public class AttendanceFillApplyRepository extends ServiceImpl<AttendanceFillApplyMapper, AttendanceFillApplyEntity> {

  /**
   * 多条件查询考勤补打卡申请列表
   *
   * @param model 条件model
   * @return 考勤补打卡申请列表
   */
  public List<AttendanceFillApplyEntity> findByFillApplyConditionModel(FillApplyConditionModel model) {
    return this.baseMapper.findByFillApplyConditionModel(model);
  }

  /**
   * 通过ID集合查询补打卡申请信息
   *
   * @param ids ID集合
   * @return 补打卡申请信息
   */
  public List<AttendanceFillApplyEntity> findByIds(List<String> ids) {
    return this.baseMapper.findByIds(ids);
  }

  /**
   * 补打卡申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceFillApplyEntity> 补打卡申请分页信息
   */
  public Page<AttendanceFillApplyEntity> findByConditions(Pageable pageable, AttendanceFillApplyPageDto dto) {
    Page<AttendanceFillApplyEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据流程编码获取申请实体
   *
   * @param processNumber 流程编码
   * @param tenantCode    租户编码
   * @return 申请实体
   */
  public AttendanceFillApplyEntity findByProcessNumber(String processNumber, String tenantCode) {
    return this.lambdaQuery()
        .eq(AttendanceFillApplyEntity::getTenantCode, tenantCode)
        .eq(AttendanceFillApplyEntity::getProcessNumber, processNumber)
        .one();
  }
}
