package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRulePlaceEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceRulePlaceMapper;
import org.springframework.stereotype.Component;

/**
 * 考勤规则地点表的数据库访问类 {@link AttendanceRulePlaceEntity}
 *
 * @author ning.zhang
 * @date 2022-05-05 09:44:10
 */
@Component
public class AttendanceRulePlaceRepository extends ServiceImpl<AttendanceRulePlaceMapper, AttendanceRulePlaceEntity> {

  /**
   * 通过删除考勤规则ID删除考勤规则地点
   *
   * @param ruleId 考勤规则ID
   */
  public void deleteByRuleId(String ruleId) {
    this.lambdaUpdate()
        .eq(AttendanceRulePlaceEntity::getRuleId, ruleId)
        .remove();
  }
}
