package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleSpecialDateEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceRuleSpecialDateMapper;
import org.springframework.stereotype.Component;

/**
 * 考勤规则特殊日期表的数据库访问类 {@link AttendanceRuleSpecialDateEntity}
 *
 * @author ning.zhang
 * @date 2022-05-05 09:44:48
 */
@Component
public class AttendanceRuleSpecialDateRepository extends ServiceImpl<AttendanceRuleSpecialDateMapper, AttendanceRuleSpecialDateEntity> {

  /**
   * 通过删除考勤规则ID删除考勤规则特殊日期
   *
   * @param ruleId 考勤规则ID
   */
  public void deleteByRuleId(String ruleId) {
    this.lambdaUpdate()
        .eq(AttendanceRuleSpecialDateEntity::getRuleId, ruleId)
        .remove();
  }
}
