package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleTimeEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceRuleTimeMapper;
import org.springframework.stereotype.Component;

/**
 * 考勤规则打卡时间表的数据库访问类 {@link AttendanceRuleTimeEntity}
 *
 * @author ning.zhang
 * @date 2022-05-05 09:45:01
 */
@Component
public class AttendanceRuleTimeRepository extends ServiceImpl<AttendanceRuleTimeMapper, AttendanceRuleTimeEntity> {

  /**
   * 通过删除考勤规则ID删除考勤规则打卡时间
   *
   * @param ruleId 考勤规则ID
   */
  public void deleteByRuleId(String ruleId) {
    this.lambdaUpdate()
        .eq(AttendanceRuleTimeEntity::getRuleId, ruleId)
        .remove();
  }
}
