package com.biz.crm.sfa.business.attendance.local.service;

import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordRuleEntity;
import com.biz.crm.sfa.business.attendance.local.model.RuleExecuteModel;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillClockDto;

import java.util.List;

/**
 * 考勤记录表服务接口
 *
 * @author ning.zhang
 * @date 2022-05-17 09:52:18
 */
public interface AttendanceRecordService {

  /**
   * 更新考勤记录
   *
   * @param executeModel 规则执行model
   * @param recordRuleEntity 考勤记录规则
   */
  void update(RuleExecuteModel executeModel, AttendanceRecordRuleEntity recordRuleEntity);

  /**
   * 移动端-查询补打卡考勤信息
   *
   * @param dto 参数dto
   * @return 补打卡考勤信息
   */
  List<AttendanceRecordEntity> findByAttendanceFillClockDto(AttendanceFillClockDto dto);
}
