package com.biz.crm.sfa.business.attendance.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleExecuteDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRulePageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 考勤规则表服务接口
 *
 * @author ning.zhang
 * @date 2022-05-05 09:43:07
 */
public interface AttendanceRuleService {

  /**
   * 创建考勤规则
   *
   * @param dto 请求参数dto
   * @return 考勤规则实体
   */
  AttendanceRuleEntity create(AttendanceRuleDto dto);

  /**
   * 更新考勤规则
   *
   * @param dto 请求参数dto
   * @return 考勤规则实体
   */
  AttendanceRuleEntity update(AttendanceRuleDto dto);

  /**
   * 批量删除考勤规则
   *
   * @param ids 考勤规则id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用考勤规则
   *
   * @param ids 考勤规则id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用考勤规则
   *
   * @param ids 考勤规则id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 考勤规则分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceRuleEntity> 考勤规则分页信息
   */
  Page<AttendanceRuleEntity> findByConditions(Pageable pageable, AttendanceRulePageDto dto);

  /**
   * 考勤规则执行
   *
   * @param dto 请求参数dto
   */
  void execute(AttendanceRuleExecuteDto dto);

  /**
   * 考勤规则执行定时任务
   */
  void executeTask();
}
