package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceFillApplyRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRepository;
import com.biz.crm.sfa.business.attendance.sdk.constant.AttendanceConstant;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillApplyPageDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceFillApplyVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 补打考勤申请表Vo服务接口实现
 *
 * @author ning.zhang
 * @date 2022/5/26
 */
@Slf4j
@Service
public class AttendanceFillApplyVoServiceImpl implements AttendanceFillApplyVoService {

  @Autowired
  private AttendanceFillApplyRepository attendanceFillApplyRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private AttendanceRecordRepository attendanceRecordRepository;
  @Autowired
  private UserFeignVoService userFeignVoService;
  @Autowired
  private PositionVoService positionVoService;
  @Autowired
  private UserInfoVoService userInfoVoService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private UserVoService userVoService;

  @Override
  public List<AttendanceFillApplyVo> findByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return Lists.newLinkedList();
    }
    List<AttendanceFillApplyEntity> entities = this.attendanceFillApplyRepository.findByIds(ids);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();

    }
    Set<String> recordIds = entities.stream().filter(entity -> StringUtils.isNotBlank(entity.getRecordIds()))
        .flatMap(entity -> Sets.newHashSet(entity.getRecordIds().split(",")).stream()).collect(Collectors.toSet());
    Map<String, AttendanceRecordVo> recordMap;
    List<AttendanceRecordEntity> recordEntities = this.attendanceRecordRepository.listByIds(recordIds);
    if (!CollectionUtils.isEmpty(recordEntities)) {
      recordMap = recordEntities.stream().collect(Collectors.toMap(AttendanceRecordEntity::getId, entity
          -> this.nebulaToolkitService.copyObjectByWhiteList(entity, AttendanceRecordVo.class, HashSet.class, ArrayList.class), (a, b) -> b));
    } else {
      recordMap = Maps.newHashMap();
    }
    List<AttendanceFillApplyVo> list = entities.stream().map(entity -> {
      AttendanceFillApplyVo vo = this.nebulaToolkitService.copyObjectByBlankList(entity, AttendanceFillApplyVo.class, HashSet.class, ArrayList.class);
      List<AttendanceRecordVo> recordList = Arrays.stream(entity.getRecordIds().split(",")).map(recordMap::get)
          .filter(Objects::nonNull).collect(Collectors.toList());
      vo.setRecordList(recordList);
      return vo;
    }).collect(Collectors.toList());
    this.perfectUserInfo(list);
    return list;
  }

  @Override
  public Page<AttendanceFillApplyVo> findByConditions(Pageable pageable, AttendanceFillApplyPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new AttendanceFillApplyPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    dto.setUserNames(Sets.newHashSet(loginDetails.getAccount()));
    List<PositionVo> positionList = this.positionVoService.findByParentCode(loginDetails.getPostCode());
    if (!CollectionUtils.isEmpty(positionList)) {
      List<UserInfoVo> userList = this.userInfoVoService.findByPositionCodes(positionList.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet()));
      if (!CollectionUtils.isEmpty(userList)) {
        dto.getUserNames().addAll(userList.stream().map(UserInfoVo::getUserName).collect(Collectors.toList()));
      }
    }
    //如果搜索了关键字,需要查询关键字对应的用户集合
    if (StringUtils.isNotBlank(dto.getKeyWord())) {
      UserConditionDto userConditionDto = new UserConditionDto();
      userConditionDto.setFullName(dto.getKeyWord());
      dto.setKeyWordUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
    }
    if(StringUtils.isNotEmpty(dto.getApplyDateStart())){
      dto.setApplyDateStart(String.format("%s %s",dto.getApplyDateStart(), AttendanceConstant.TIME_STR_000000));
    }
    if(StringUtils.isNotEmpty(dto.getApplyDateEnd())){
      dto.setApplyDateEnd(String.format("%s %s",dto.getApplyDateEnd(), AttendanceConstant.TIME_STR_235959));
    }
    Page<AttendanceFillApplyEntity> entityPage = this.attendanceFillApplyRepository.findByConditions(pageable, dto);
    Page<AttendanceFillApplyVo> pageResult = new Page<>(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return pageResult;
    }
    List<AttendanceFillApplyVo> list = (List<AttendanceFillApplyVo>) this.nebulaToolkitService.copyCollectionByBlankList(entityPage.getRecords()
        , AttendanceFillApplyEntity.class, AttendanceFillApplyVo.class, HashSet.class, ArrayList.class);
    this.perfectUserInfo(list);
    pageResult.setRecords(list);
    return pageResult;
  }

  @Override
  public Page<AttendanceFillApplyVo> findDetailByConditions(Pageable pageable,
      AttendanceFillApplyPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new AttendanceFillApplyPageDto());
    if (StringUtils.isNotBlank(dto.getUserRealName())) {
      UserConditionDto userConditionDto = new UserConditionDto();
      userConditionDto.setFullName(dto.getUserRealName());
      dto.setUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    if(StringUtils.isNotEmpty(dto.getApplyDateStart())){
      dto.setApplyDateStart(String.format("%s %s",dto.getApplyDateStart(), AttendanceConstant.TIME_STR_000000));
    }
    if(StringUtils.isNotEmpty(dto.getApplyDateEnd())){
      dto.setApplyDateEnd(String.format("%s %s",dto.getApplyDateEnd(), AttendanceConstant.TIME_STR_235959));
    }
    Page<AttendanceFillApplyEntity> entityPage = this.attendanceFillApplyRepository.findByConditions(pageable, dto);
    Page<AttendanceFillApplyVo> pageResult = new Page<>(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return pageResult;
    }
    List<AttendanceFillApplyVo> list = (List<AttendanceFillApplyVo>) this.nebulaToolkitService.copyCollectionByBlankList(entityPage.getRecords()
        , AttendanceFillApplyEntity.class, AttendanceFillApplyVo.class, HashSet.class, ArrayList.class);
    this.perfectRecordInfo(list);
    pageResult.setRecords(list);
    return pageResult;
  }

  /**
   * 完善补打卡申请用户信息
   *
   * @param list 补打卡申请
   */
  private void perfectUserInfo(List<AttendanceFillApplyVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> userNames = list.stream().map(AttendanceFillApplyVo::getUserName).collect(Collectors.toSet());
    List<UserVo> userVoList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
    if (CollectionUtils.isEmpty(userVoList)) {
      return;
    }
    Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
    list.forEach(vo -> {
      UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
      vo.setUserRealName(userVo.getFullName());
      vo.setPositionCode(userVo.getPositionCode());
      vo.setPositionName(userVo.getPositionName());
      vo.setOrgCode(userVo.getOrgCode());
      vo.setOrgName(userVo.getOrgName());
    });
  }

  private void perfectRecordInfo(List<AttendanceFillApplyVo> list){
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> recordIdSet = new HashSet<>();
    list.forEach(vo -> {
      String recordIds = vo.getRecordIds();
      if(StringUtils.isNotBlank(recordIds)){
        String[] split = recordIds.split(",");
        for (String s : split) {
          recordIdSet.add(s);
        }
      }
    });
    List<AttendanceRecordEntity> recordEntities = this.attendanceRecordRepository.listByIds(recordIdSet);
    if(CollectionUtils.isEmpty(recordEntities)){
      return;
    }
    Map<String, AttendanceRecordEntity> attendanceRecordEntityMap = recordEntities.stream().collect(Collectors.toMap(AttendanceRecordEntity::getId, t -> t, (a, b) -> b));

    list.forEach(vo -> {
      String recordIds = vo.getRecordIds();
      if(StringUtils.isNotBlank(recordIds)){
        String[] split = recordIds.split(",");
        for (String s : split) {
          AttendanceRecordEntity attendanceRecordEntity = attendanceRecordEntityMap.get(s);
          if(Objects.nonNull(attendanceRecordEntity)){
            //考勤日期
            String ruleDate = attendanceRecordEntity.getRuleDate();
            //打卡类型
            String clockType = attendanceRecordEntity.getClockType();
            AttendanceClockType attendanceClockType = AttendanceClockType.getByDictCode(clockType);
            if(Objects.nonNull(attendanceClockType)){
              String value = attendanceClockType.getValue();
              //打卡时间
              String clockTime = attendanceRecordEntity.getClockTime() == null?"":attendanceRecordEntity.getClockTime();
              String clockTypeStr = String.format("%s (%s)", value, clockTime);
              vo.setClockType(clockTypeStr);
            }
            vo.setRuleDate(ruleDate);
          }
        }
      }
    });
  }
}
