package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordPictureEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordPictureRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRecordPictureService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceClockDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 考勤记录照片表服务实现类
 *
 * @author ning.zhang
 * @date 2022-05-19 10:20:29
 */
@Slf4j
@Service("attendanceRecordPictureService")
public class AttendanceRecordPictureServiceImpl implements AttendanceRecordPictureService {

  @Autowired
  private AttendanceRecordPictureRepository attendanceRecordPictureRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(AttendanceClockDto dto) {
    Validate.notBlank(dto.getRecordId(), "考勤记录ID不能为空");
    this.attendanceRecordPictureRepository.deleteByRecordId(dto.getRecordId());
    if (CollectionUtils.isEmpty(dto.getPictureList())) {
      return;
    }
    this.updateValidation(dto);
    List<AttendanceRecordPictureEntity> entities = dto.getPictureList().stream().map(pictureDto -> {
      AttendanceRecordPictureEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(pictureDto, AttendanceRecordPictureEntity.class, HashSet.class, ArrayList.class);
      entity.setRecordId(dto.getRecordId());
      entity.setTenantCode(TenantUtils.getTenantCode());
      return entity;
    }).collect(Collectors.toList());
    this.attendanceRecordPictureRepository.saveBatch(entities);
  }

  /**
   * 在修改AttendanceRecordPicture模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param dto 检查对象
   */
  private void updateValidation(AttendanceClockDto dto) {
    dto.getPictureList().forEach(pictureDto -> {
      Validate.notBlank(pictureDto.getFileName(), "缺失文件名称");
      Validate.notBlank(pictureDto.getSuffix(), "缺失文件后缀");
      Validate.notBlank(pictureDto.getObjectName(), "缺失对象名");
      Validate.notBlank(pictureDto.getUrl(), "缺失访问路径");
    });
  }
}
