package com.biz.crm.sfa.business.attendance.local.service.observer;

import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceFillApplyRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRepository;
import com.biz.crm.sfa.business.attendance.sdk.constant.AttendanceConstant;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendancePlaceStatus;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Set;


/**
 * 考勤补打卡审批回调类
 *
 * @author ning.zhang
 * @date 2022/6/2
 */
@Component
public class AttendanceFillApplyCallbackListener implements CallBackListener {

  @Autowired
  private AttendanceFillApplyRepository attendanceFillApplyRepository;
  @Autowired
  private AttendanceRecordRepository attendanceRecordRepository;

  @Override
  @Transactional
  public void onCallBack(CallBackDto dto) {
    if (!dto.getFormType().equals(AttendanceConstant.ATTENDANCE_FILL_CLOCK_APPLY_PROCESS_FORM_TYPE)) {
      return;
    }
    AttendanceFillApplyEntity applyEntity = this.attendanceFillApplyRepository.findByProcessNumber(dto.getProcessNo(), TenantUtils.getTenantCode());
    if (Objects.isNull(applyEntity)) {
      return;
    }
    //校验审批状态
    Validate.isTrue(applyEntity.getProcessStatus().equals(ActApproveStatusEnum.APPROVING.getCode()), "此申请非审批中状态，无法进行操作！");
    //根据回调类别处理对应业务
    if (StringUtils.equals(String.valueOf(dto.getProcessState()), ActApproveStatusEnum.APPROVED.getCode())) {
      //审批通过业务处理
      applyEntity.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
      // 修改考勤状态为 正常.1、获取规则列表、2执行更新
      Set<String> recordIds = Sets.newHashSet(applyEntity.getRecordIds().split(","));
      List<AttendanceRecordEntity> recordEntities = this.attendanceRecordRepository.listByIds(recordIds);
      Validate.isTrue(!CollectionUtils.isEmpty(recordEntities), "此申请找不到需要执行的打卡信息，无法进行操作！");
      for (AttendanceRecordEntity recordEntity : recordEntities) {
        recordEntity.setRemark(StringUtils.isBlank(recordEntity.getRemark())
            ? "补打卡" : String.format("%s;%s", recordEntity.getRemark(), "补打卡"));
        recordEntity.setClockStatus(AttendanceClockStatus.OK.getDictCode());
        recordEntity.setClockPlaceStatus(AttendancePlaceStatus.OK.getDictCode());
        recordEntity.setClockTime(recordEntity.getRuleClockTime());
      }
      this.attendanceRecordRepository.updateBatchById(recordEntities);
    } else if (StringUtils.equals(String.valueOf(dto.getProcessState()), ActApproveStatusEnum.REJECTED.getCode())) {
      //审批驳回业务处理
      applyEntity.setProcessStatus(ActApproveStatusEnum.REJECTED.getCode());
    } else if (StringUtils.equals(String.valueOf(dto.getProcessState()), ActApproveStatusEnum.INTERRUPT.getCode())) {
      //流程追回业务处理
      applyEntity.setProcessStatus(ActApproveStatusEnum.INTERRUPT.getCode());
    }
    this.attendanceFillApplyRepository.updateById(applyEntity);
  }
}
