/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceRecordMapper;
import com.biz.crm.sfa.business.attendance.sdk.constant.AttendanceConstant;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillClockDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.TodayHistoryRecordDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AttendanceRecordRepository
extends ServiceImpl<AttendanceRecordMapper, AttendanceRecordEntity> {
    public void deleteByRuleDateAndUsedStatus(String tenantCode, String ruleDate, String usedStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AttendanceRecordEntity::getRuleDate, (Object)ruleDate)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(AttendanceRecordEntity::getUsedStatus, (Object)usedStatus)).remove();
    }

    public List<AttendanceRecordEntity> findByRuleDateAndUsedStatus(String tenantCode, String ruleDate, String usedStatus) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AttendanceRecordEntity::getRuleDate, (Object)ruleDate)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(AttendanceRecordEntity::getUsedStatus, (Object)usedStatus)).list();
    }

    public List<AttendanceRecordEntity> findByUserNameAndRuleDateAndClockType(String tenantCode, String userName, String ruleDate, String clockType) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AttendanceRecordEntity::getRuleDate, (Object)ruleDate)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(AttendanceRecordEntity::getUserName, (Object)userName)).eq(AttendanceRecordEntity::getClockType, (Object)clockType)).list();
    }

    public List<AttendanceRecordEntity> findByUserNameAndRuleTimeId(String tenantCode, String userName, String ruleTimeId) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AttendanceRecordEntity::getRuleTimeId, (Object)ruleTimeId)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(AttendanceRecordEntity::getUserName, (Object)userName)).list();
    }

    public void updateUsedStatusByUserNameAndRecordRuleId(String tenantCode, String userName, String recordRuleId, String usedStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AttendanceRecordEntity::getUserName, (Object)userName)).eq(AttendanceRecordEntity::getRecordRuleId, (Object)recordRuleId)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(AttendanceRecordEntity::getUsedStatus, (Object)usedStatus)).update();
    }

    public List<AttendanceRecordEntity> findByTodayHistoryRecordDto(TodayHistoryRecordDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)dto.getTenantCode())).eq(AttendanceRecordEntity::getClockType, (Object)dto.getClockType())).eq(AttendanceRecordEntity::getUserName, (Object)dto.getUserName())).eq(AttendanceRecordEntity::getRuleDate, (Object)LocalDateTime.now().format(AttendanceConstant.YYYY_MM_DD))).le(AttendanceRecordEntity::getRuleClockTime, (Object)LocalDateTime.now().format(AttendanceConstant.HH_MM_SS))).ne(UuidEntity::getId, (Object)dto.getBeforeRecordId())).list();
    }

    public void deleteByRuleIdsAndRuleDate(String tenantCode, List<String> ruleIds, String ruleDate) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AttendanceRecordEntity::getRuleDate, (Object)ruleDate)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(AttendanceRecordEntity::getRuleId, ruleIds)).remove();
    }

    public List<AttendanceRecordEntity> findByAttendanceFillClockDto(AttendanceFillClockDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)dto.getTenantCode())).between(AttendanceRecordEntity::getRuleDate, (Object)dto.getBeginTime(), (Object)dto.getEndTime())).eq(AttendanceRecordEntity::getUserName, (Object)dto.getUserName())).ne(AttendanceRecordEntity::getClockStatus, (Object)AttendanceClockStatus.OK.getDictCode())).orderByAsc(AttendanceRecordEntity::getRuleClockTime)).list();
    }

    public List<AttendanceRecordEntity> findByIds(List<String> ids) {
        return ((AttendanceRecordMapper)this.baseMapper).findByIds(ids);
    }
}

