/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyPictureEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceFillApplyPictureRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceFillApplyPictureService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillClockDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceFillApplyPictureService")
public class AttendanceFillApplyPictureServiceImpl
implements AttendanceFillApplyPictureService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceFillApplyPictureServiceImpl.class);
    @Autowired
    private AttendanceFillApplyPictureRepository attendanceFillApplyPictureRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(AttendanceFillClockDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u8865\u6253\u5361\u7533\u8bf7\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.attendanceFillApplyPictureRepository.deleteByApplyId(dto.getId());
        if (CollectionUtils.isEmpty((Collection)dto.getPictureList())) {
            return;
        }
        this.updateValidation(dto);
        List entities = dto.getPictureList().stream().map(pictureDto -> {
            AttendanceFillApplyPictureEntity entity = (AttendanceFillApplyPictureEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(pictureDto, AttendanceFillApplyPictureEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setApplyId(dto.getId());
            entity.setTenantCode(dto.getTenantCode());
            return entity;
        }).collect(Collectors.toList());
        this.attendanceFillApplyPictureRepository.saveBatch(entities);
    }

    private void updateValidation(AttendanceFillClockDto dto) {
        dto.getPictureList().forEach(pictureDto -> {
            Validate.notBlank((CharSequence)pictureDto.getObjectName(), (String)"\u7f3a\u5931\u5bf9\u8c61\u540d", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)pictureDto.getFileName(), (String)"\u7f3a\u5931\u6587\u4ef6\u540d\u79f0", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)pictureDto.getSuffix(), (String)"\u7f3a\u5931\u6587\u4ef6\u540e\u7f00", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)pictureDto.getUrl(), (String)"\u7f3a\u5931\u8bbf\u95ee\u8def\u5f84", (Object[])new Object[0]);
        });
    }
}

